/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Left
extends AbstractFunction {
    public Left() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRING, "text", "The source text."), new ArgDescriptor(ArgType.OPT_FLOAT, "number", "How many characters to extract. (Optional, default is 1)")});
    }

    public String getName() {
        return "LEFT";
    }

    public String getCategoryName() {
        return "Text";
    }

    public String getFunctionSummary() {
        return "Returns the prefix of a string.";
    }

    public Class<?> getReturnType() {
        return String.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        int count;
        String text = FunctionUtil.getArgAsString((Object)args[0]);
        if (args.length == 1) {
            count = 1;
        } else {
            try {
                count = (int)FunctionUtil.getArgAsLong((Object)args[1]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to a count in a call to LEFT().");
            }
            if (count < 0) {
                throw new IllegalArgumentException("illegal character count in call to LEFT().");
            }
        }
        if (count >= text.length()) {
            return text;
        }
        return text.substring(0, count);
    }
}

