/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Largest
extends AbstractFunction {
    public Largest() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRICT_ANY_LIST, "list", "A list of numbers."), new ArgDescriptor(ArgType.INT, "k", "Specifies the rank of the number that will be selected.")});
    }

    public String getName() {
        return "LARGEST";
    }

    public String getCategoryName() {
        return "List";
    }

    public String getFunctionSummary() {
        return "Returns the kth largest element of a list of numbers.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        long k;
        List list = (List)args[0];
        if (list.isEmpty()) {
            throw new IllegalArgumentException("illegal empty list argument in call to LARGEST().");
        }
        double[] array = new double[list.size()];
        int i = 0;
        for (Object listElement : list) {
            try {
                array[i++] = FunctionUtil.getArgAsDouble(listElement);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(FunctionUtil.getOrdinal((int)i) + " list element in call to LARGEST() is not a number: " + e.getMessage());
            }
        }
        try {
            k = FunctionUtil.getArgAsLong((Object)args[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to an integer argument in a call to LARGEST().");
        }
        if (k <= 0L) {
            throw new IllegalArgumentException("invalid index " + args[1] + " in a call to LARGEST().");
        }
        if (k > (long)array.length) {
            throw new IllegalArgumentException("index " + args[1] + " is too large for a list w/ " + array.length + " elements in a call to LARGEST().");
        }
        return this.kthSmallest(array, array.length - (int)k);
    }

    private double kthSmallest(double[] array, int k) {
        int first = 0;
        int last = array.length - 1;
        int middle;
        while ((middle = this.partition(array, first, last)) != k) {
            if (middle < k) {
                first = middle + 1;
                continue;
            }
            last = middle - 1;
        }
        return array[k];
    }

    private int partition(double[] array, int first, int last) {
        int pivotIndex = this.medianOf3PiviotPosition(array, first, last);
        double pivotValue = array[pivotIndex];
        this.swap(array, pivotIndex, last);
        int storeIndex = first;
        for (int i = first; i < last; ++i) {
            if (!(array[i] <= pivotValue)) continue;
            this.swap(array, i, storeIndex);
            ++storeIndex;
        }
        this.swap(array, storeIndex, last);
        return storeIndex;
    }

    private int medianOf3PiviotPosition(double[] array, int first, int last) {
        int middle = (first + last) / 2;
        if (array[first] > array[last]) {
            int temp = first;
            first = last;
            last = temp;
        }
        if (array[middle] > array[last]) {
            return last;
        }
        return array[first] > array[middle] ? first : middle;
    }

    private void swap(double[] array, int i, int j) {
        double temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}

