/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import org.cytoscape.file_transfer.internal.URLToSandboxTask;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class URLToSandboxTaskFactory
extends AbstractTaskFactory {
    public static final String DESCRIPTION = "Transfer a URL-named file to sandbox";
    public static final String LONG_DESCRIPTION = "Given a URL for a file, resolve it to an actual file, then download it and write it to ```fileName``` in a sandbox (```sandboxName```). If the file already exists, it will be overwritten only if ```overwrite``` is true. Either way, return the file path (```filePath```) and the count of bytes read.";
    private File sandboxParentDirFile;

    public URLToSandboxTaskFactory(File sandboxParentDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
    }

    public boolean isReady() {
        return true;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new URLToSandboxTask(this.sandboxParentDirFile)});
    }
}

