/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.cytoscape.file_transfer.internal.CyRESTAbstractTask;
import org.cytoscape.file_transfer.internal.RemoveSandboxResult;
import org.cytoscape.file_transfer.internal.SandboxUtils;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class RemoveSandboxTask
extends CyRESTAbstractTask {
    @Tunable(description="sandboxName", longDescription="Name of sandbox to remove", exampleStringValue="mySandbox")
    public String sandboxName = "";
    private File sandboxParentDirFile;

    @ProvidesTitle
    public String getTitle() {
        return "Remove a Cytoscape sandbox";
    }

    public RemoveSandboxTask(File sandboxParentDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
    }

    public void run(TaskMonitor taskMon) throws Exception {
        File sandboxDirFile = SandboxUtils.getAbsSandboxFile(this.sandboxParentDirFile, this.sandboxName);
        String sandboxPath = sandboxDirFile.getCanonicalPath();
        if (sandboxDirFile.exists()) {
            FileUtils.forceDelete((File)sandboxDirFile);
            this.result = new RemoveSandboxResult(sandboxPath, true);
        } else {
            this.result = new RemoveSandboxResult(sandboxPath, false);
        }
    }

    public static String getExample() {
        return RemoveSandboxTask.getJson(new RemoveSandboxResult("/User/CytoscapeConfiguration/FileTransfer/MySandbox", true));
    }
}

