/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableHandler;

public abstract class AbstractTunableHandler
implements TunableHandler {
    private final Field field;
    private final Method getter;
    private final Method setter;
    private final Reference<?> instance;
    private final Tunable tunable;
    private double offset = 0.0;
    public static final String TOOLTIP = "tooltip";
    public static final String GRAVITY = "gravity";
    public static final String CONTEXT = "context";
    public static final String FORMAT = "format";

    public AbstractTunableHandler(Field field, Object instance, Tunable tunable) {
        this.field = field;
        this.getter = null;
        this.setter = null;
        this.instance = new WeakReference<Object>(instance);
        this.tunable = tunable;
    }

    public AbstractTunableHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        this.field = null;
        this.getter = getter;
        this.setter = setter;
        this.instance = new WeakReference<Object>(instance);
        this.tunable = tunable;
    }

    @Override
    public final Class<?> getType() {
        return this.field != null ? this.field.getType() : this.getter.getReturnType();
    }

    @Override
    public final Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.field != null ? this.field.get(this.instance.get()) : this.getter.invoke(this.instance.get(), new Object[0]);
    }

    @Override
    public void setValue(Object newValue) throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            this.field.set(this.instance.get(), newValue);
        } else {
            this.setter.invoke(this.instance.get(), newValue);
        }
    }

    @Override
    public final String getDescription() {
        return this.tunable.description();
    }

    @Override
    public final String getLongDescription() {
        return this.tunable.longDescription();
    }

    @Override
    public final String getExampleStringValue() {
        return this.tunable.exampleStringValue();
    }

    @Override
    public final String[] getGroups() {
        return this.tunable.groups();
    }

    @Override
    public final boolean controlsMutuallyExclusiveNestedChildren() {
        return this.tunable.xorChildren();
    }

    @Override
    public final String getChildKey() {
        return this.tunable.xorKey();
    }

    @Override
    public final String dependsOn() {
        return this.tunable.dependsOn();
    }

    @Override
    public final String[] listenForChange() {
        return this.tunable.listenForChange();
    }

    @Override
    public final String getName() {
        if (this.field != null) {
            return this.field.getName();
        }
        return this.setter.getName().substring(3);
    }

    @Override
    public final String getQualifiedName() {
        String unqualifiedClassName = this.field == null ? this.getter.getDeclaringClass().toString() : this.field.getDeclaringClass().toString();
        return unqualifiedClassName.substring(unqualifiedClassName.lastIndexOf(".") + 1) + "." + this.getName();
    }

    @Override
    public final Properties getParams() throws IllegalArgumentException {
        String rawString = this.tunable.params();
        Properties keyValuesPairs = new Properties();
        keyValuesPairs.put(GRAVITY, Double.toString(this.tunable.gravity() + this.offset));
        keyValuesPairs.put(TOOLTIP, this.tunable.tooltip());
        keyValuesPairs.put(CONTEXT, this.tunable.context());
        if (this.tunable.format() != null && this.tunable.format().length() > 0) {
            keyValuesPairs.put(FORMAT, this.tunable.format());
        }
        StringBuilder key = null;
        StringBuilder value = null;
        ParamsParseState state = ParamsParseState.KEY_START;
        boolean escaped = false;
        block6: for (int i = 0; i < rawString.length(); ++i) {
            char ch = rawString.charAt(i);
            switch (state) {
                case KEY_START: {
                    key = new StringBuilder();
                    if (!Character.isLetter(ch)) {
                        throw new IllegalArgumentException(this.getName() + "'s getParams() returns an invalid key.");
                    }
                    key.append(ch);
                    state = ParamsParseState.LOOKING_FOR_EQUAL_SIGN;
                    continue block6;
                }
                case LOOKING_FOR_EQUAL_SIGN: {
                    if (ch == '=') {
                        state = ParamsParseState.VALUE_START;
                        continue block6;
                    }
                    if (!Character.isLetter(ch)) {
                        throw new IllegalArgumentException(this.getName() + "'s getParams() returns an invalid key.");
                    }
                    key.append(ch);
                    continue block6;
                }
                case VALUE_START: {
                    value = new StringBuilder();
                    if (ch == ';') {
                        throw new IllegalArgumentException(this.getName() + "'s getParams() returns an invalid value.");
                    }
                    if (ch == '\\') {
                        escaped = true;
                    } else {
                        value.append(ch);
                    }
                    state = ParamsParseState.LOOKING_FOR_SEMICOLON;
                    continue block6;
                }
                case LOOKING_FOR_SEMICOLON: {
                    if (escaped) {
                        value.append(ch);
                        escaped = false;
                        continue block6;
                    }
                    if (ch == ';') {
                        keyValuesPairs.setProperty(key.toString(), value.toString());
                        state = ParamsParseState.KEY_START;
                        continue block6;
                    }
                    if (ch == '\\') {
                        escaped = true;
                        continue block6;
                    }
                    value.append(ch);
                }
            }
        }
        if (escaped) {
            throw new IllegalArgumentException(this.getName() + "'s getParams() returns an invalid escaped character.");
        }
        if (state != ParamsParseState.KEY_START && state != ParamsParseState.LOOKING_FOR_SEMICOLON) {
            throw new IllegalArgumentException(this.getName() + "'s getParams() returns an incomplete string: \"" + rawString + "\".");
        }
        if (key != null) {
            if (value == null) {
                throw new IllegalArgumentException(this.getName() + "'s getParams() returns a key without a value.");
            }
            keyValuesPairs.setProperty(key.toString(), value.toString());
        }
        return keyValuesPairs;
    }

    public final String getContext() {
        return this.tunable.context();
    }

    public final String getTooltip() {
        return this.tunable.tooltip();
    }

    public final double getGravity() {
        return this.tunable.gravity() + this.offset;
    }

    public final boolean getRequired() {
        return this.tunable.required();
    }

    public final String getFormat() {
        return this.tunable.format();
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    private static enum ParamsParseState {
        KEY_START,
        LOOKING_FOR_EQUAL_SIGN,
        VALUE_START,
        LOOKING_FOR_SEMICOLON;

    }
}

