/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.presentation.property.values.AbstractVisualPropertyValue;
import org.cytoscape.view.presentation.property.values.NodeShape;

public final class NodeShapeVisualProperty
extends AbstractVisualProperty<NodeShape> {
    public static final NodeShape RECTANGLE = new NodeShapeImpl("Rectangle", "RECTANGLE");
    public static final NodeShape ROUND_RECTANGLE = new NodeShapeImpl("Round Rectangle", "ROUND_RECTANGLE");
    public static final NodeShape TRIANGLE = new NodeShapeImpl("Triangle", "TRIANGLE");
    public static final NodeShape PARALLELOGRAM = new NodeShapeImpl("Parallelogram", "PARALLELOGRAM");
    public static final NodeShape DIAMOND = new NodeShapeImpl("Diamond", "DIAMOND");
    public static final NodeShape ELLIPSE = new NodeShapeImpl("Ellipse", "ELLIPSE");
    public static final NodeShape HEXAGON = new NodeShapeImpl("Hexagon", "HEXAGON");
    public static final NodeShape OCTAGON = new NodeShapeImpl("Octagon", "OCTAGON");
    private static final DiscreteRange<NodeShape> NODE_SHAPE_RANGE;
    private static final Map<String, NodeShape> DEFAULT_SHAPES;

    public NodeShapeVisualProperty(NodeShape defaultValue, String id, String displayName, Class<? extends CyIdentifiable> modelDataType) {
        super(defaultValue, NODE_SHAPE_RANGE, id, displayName, modelDataType);
    }

    @Override
    public String toSerializableString(NodeShape value) {
        return value.getSerializableString();
    }

    @Override
    public NodeShape parseSerializableString(String value) {
        NodeShape shape = null;
        if (value != null) {
            shape = DEFAULT_SHAPES.get(value.toUpperCase());
        }
        if (shape == null) {
            for (NodeShape ns : NODE_SHAPE_RANGE.values()) {
                if (!ns.getSerializableString().equalsIgnoreCase(value)) continue;
                shape = ns;
                break;
            }
        }
        return shape;
    }

    public static boolean isDefaultShape(NodeShape shape) {
        for (NodeShape s : DEFAULT_SHAPES.values()) {
            if (!shape.equals(s)) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_SHAPES = new HashMap<String, NodeShape>();
        DEFAULT_SHAPES.put(RECTANGLE.getSerializableString().toUpperCase(), RECTANGLE);
        DEFAULT_SHAPES.put(ROUND_RECTANGLE.getSerializableString().toUpperCase(), ROUND_RECTANGLE);
        DEFAULT_SHAPES.put(TRIANGLE.getSerializableString().toUpperCase(), TRIANGLE);
        DEFAULT_SHAPES.put(PARALLELOGRAM.getSerializableString().toUpperCase(), PARALLELOGRAM);
        DEFAULT_SHAPES.put(DIAMOND.getSerializableString().toUpperCase(), DIAMOND);
        DEFAULT_SHAPES.put(ELLIPSE.getSerializableString().toUpperCase(), ELLIPSE);
        DEFAULT_SHAPES.put(HEXAGON.getSerializableString().toUpperCase(), HEXAGON);
        DEFAULT_SHAPES.put(OCTAGON.getSerializableString().toUpperCase(), OCTAGON);
        DEFAULT_SHAPES.put("RECT", RECTANGLE);
        DEFAULT_SHAPES.put("ROUNDRECT", ROUND_RECTANGLE);
        DEFAULT_SHAPES.put("ROUND_RECT", ROUND_RECTANGLE);
        DEFAULT_SHAPES.put("BOX", RECTANGLE);
        DEFAULT_SHAPES.put("CIRCLE", ELLIPSE);
        DEFAULT_SHAPES.put("VER_ELLIPSIS", ELLIPSE);
        DEFAULT_SHAPES.put("HOR_ELLIPSIS", ELLIPSE);
        DEFAULT_SHAPES.put("RHOMBUS", PARALLELOGRAM);
        NODE_SHAPE_RANGE = new DiscreteRange<NodeShape>(NodeShape.class, new HashSet<NodeShape>(DEFAULT_SHAPES.values()));
    }

    private static final class NodeShapeImpl
    extends AbstractVisualPropertyValue
    implements NodeShape {
        public NodeShapeImpl(String displayName, String serializableString) {
            super(displayName, serializableString);
        }
    }
}

