/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.BendFactory;
import org.cytoscape.view.presentation.property.values.Handle;

public class EdgeBendVisualProperty
extends AbstractVisualProperty<Bend> {
    public static final Bend DEFAULT_EDGE_BEND = new EmptyBendImpl();
    private static final Range<Bend> EDGE_BEND_RANGE = new ContinuousRange<Bend>(Bend.class, DEFAULT_EDGE_BEND, DEFAULT_EDGE_BEND, true, true);
    private BendFactory bendFactory;

    public EdgeBendVisualProperty(Bend defaultValue, String id, String displayName) {
        super(defaultValue, EDGE_BEND_RANGE, id, displayName, CyEdge.class);
    }

    public void setBendFactory(BendFactory bendFactory) {
        this.bendFactory = bendFactory;
    }

    @Override
    public String toSerializableString(Bend value) {
        try {
            return value.getSerializableString();
        }
        catch (ClassCastException ex) {
            System.out.println("Bend: " + this.getIdString() + ", " + this.getDisplayName() + " - - " + value);
            return null;
        }
    }

    @Override
    public Bend parseSerializableString(String value) {
        if (value == null) {
            return DEFAULT_EDGE_BEND;
        }
        return this.bendFactory.parseSerializableString(value);
    }

    private static final class EmptyBendImpl
    implements Bend {
        private EmptyBendImpl() {
        }

        @Override
        public List<Handle> getAllHandles() {
            return Collections.emptyList();
        }

        @Override
        public void insertHandleAt(int index, Handle handle) {
            throw new UnsupportedOperationException("This is a default immutable Bend object.");
        }

        @Override
        public void removeHandleAt(int handleIndex) {
            throw new UnsupportedOperationException("This is a default immutable Bend object.");
        }

        @Override
        public void removeAllHandles() {
            throw new UnsupportedOperationException("This is a default immutable Bend object.");
        }

        @Override
        public int getIndex(Handle handle) {
            return -1;
        }

        @Override
        public String getSerializableString() {
            return null;
        }

        public String toString() {
            return "None";
        }
    }
}

