/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.util.HashSet;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.model.Range;

public final class BooleanVisualProperty
extends AbstractVisualProperty<Boolean> {
    private static final Range<Boolean> BOOLEAN_RANGE;

    public BooleanVisualProperty(Boolean def, String id, String displayName, Class<? extends CyIdentifiable> modelDataType) {
        this(def, id, displayName, false, modelDataType);
    }

    public BooleanVisualProperty(Boolean def, String id, String displayName, Boolean ignoreDefault, Class<? extends CyIdentifiable> modelDataType) {
        super(def, BOOLEAN_RANGE, id, displayName, modelDataType);
        this.shouldIgnoreDefault = ignoreDefault;
    }

    @Override
    public String toSerializableString(Boolean value) {
        return value.toString();
    }

    @Override
    public Boolean parseSerializableString(String text) {
        return Boolean.valueOf(text);
    }

    static {
        HashSet<Boolean> bRange = new HashSet<Boolean>();
        bRange.add(true);
        bRange.add(false);
        BOOLEAN_RANGE = new DiscreteRange<Boolean>(Boolean.class, bRange);
    }
}

