/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.presentation.property.values.AbstractVisualPropertyValue;
import org.cytoscape.view.presentation.property.values.ArrowShape;

public final class ArrowShapeVisualProperty
extends AbstractVisualProperty<ArrowShape> {
    public static final ArrowShape NONE = new ArrowShapeImpl("None", "NONE");
    public static final ArrowShape DIAMOND = new ArrowShapeImpl("Diamond", "DIAMOND");
    public static final ArrowShape OPEN_DIAMOND = new ArrowShapeImpl("Open Diamond", "OPEN_DIAMOND");
    public static final ArrowShape DELTA = new ArrowShapeImpl("Delta", "DELTA");
    public static final ArrowShape OPEN_DELTA = new ArrowShapeImpl("Open Delta", "OPEN_DELTA");
    public static final ArrowShape CROSS_DELTA = new ArrowShapeImpl("Cross Delta", "CROSS_DELTA");
    public static final ArrowShape CROSS_OPEN_DELTA = new ArrowShapeImpl("Cross Open Delta", "CROSS_OPEN_DELTA");
    public static final ArrowShape ARROW = new ArrowShapeImpl("Arrow", "ARROW");
    public static final ArrowShape T = new ArrowShapeImpl("T", "T");
    public static final ArrowShape CIRCLE = new ArrowShapeImpl("Circle", "CIRCLE");
    public static final ArrowShape OPEN_CIRCLE = new ArrowShapeImpl("Open Circle", "OPEN_CIRCLE");
    public static final ArrowShape HALF_CIRCLE = new ArrowShapeImpl("Half Circle", "HALF_CIRCLE");
    public static final ArrowShape OPEN_HALF_CIRCLE = new ArrowShapeImpl("Open Half Circle", "OPEN_HALF_CIRCLE");
    public static final ArrowShape SQUARE = new ArrowShapeImpl("Square", "SQUARE");
    public static final ArrowShape OPEN_SQUARE = new ArrowShapeImpl("Open Square", "OPEN_SQUARE");
    public static final ArrowShape HALF_TOP = new ArrowShapeImpl("Half Top", "HALF_TOP");
    public static final ArrowShape HALF_BOTTOM = new ArrowShapeImpl("Half Bottom", "HALF_BOTTOM");
    public static final ArrowShape DELTA_SHORT_1 = new ArrowShapeImpl("Delta Short 1", "DELTA_SHORT_1");
    public static final ArrowShape DELTA_SHORT_2 = new ArrowShapeImpl("Delta Short 2", "DELTA_SHORT_2");
    public static final ArrowShape ARROW_SHORT = new ArrowShapeImpl("Arrow Short", "ARROW_SHORT");
    public static final ArrowShape DIAMOND_SHORT_1 = new ArrowShapeImpl("Diamond Short 1", "DIAMOND_SHORT_1");
    public static final ArrowShape DIAMOND_SHORT_2 = new ArrowShapeImpl("Diamond Short 2", "DIAMOND_SHORT_2");
    private static final DiscreteRange<ArrowShape> ARROW_SHAPE_RANGE;
    private static final Map<String, ArrowShape> DEFAULT_SHAPES;

    private static void putShapes(ArrowShape ... shapes) {
        for (ArrowShape shape : shapes) {
            DEFAULT_SHAPES.put(shape.getSerializableString().toUpperCase(), shape);
        }
    }

    public ArrowShapeVisualProperty(ArrowShape defaultValue, String id, String displayName, Class<? extends CyIdentifiable> modelDataType) {
        super(defaultValue, ARROW_SHAPE_RANGE, id, displayName, modelDataType);
    }

    @Override
    public String toSerializableString(ArrowShape value) {
        return value.getSerializableString();
    }

    @Override
    public ArrowShape parseSerializableString(String value) {
        ArrowShape shape = null;
        if (value != null) {
            shape = DEFAULT_SHAPES.get(value.toUpperCase());
        }
        if (shape == null) {
            for (ArrowShape as : ARROW_SHAPE_RANGE.values()) {
                if (!as.getSerializableString().equalsIgnoreCase(value)) continue;
                shape = as;
                break;
            }
        }
        return shape;
    }

    public static boolean isDefaultShape(ArrowShape shape) {
        return DEFAULT_SHAPES.containsValue(shape);
    }

    static {
        DEFAULT_SHAPES = new HashMap<String, ArrowShape>();
        ArrowShapeVisualProperty.putShapes(NONE, DIAMOND, OPEN_DIAMOND, DELTA, OPEN_DELTA, CROSS_DELTA, CROSS_OPEN_DELTA);
        ArrowShapeVisualProperty.putShapes(ARROW, T, CIRCLE, OPEN_CIRCLE, HALF_CIRCLE, OPEN_HALF_CIRCLE, SQUARE, OPEN_SQUARE);
        ArrowShapeVisualProperty.putShapes(HALF_TOP, HALF_BOTTOM, DELTA_SHORT_1, DELTA_SHORT_2, ARROW_SHORT, DIAMOND_SHORT_1, DIAMOND_SHORT_2);
        ARROW_SHAPE_RANGE = new DiscreteRange<ArrowShape>(ArrowShape.class, new HashSet<ArrowShape>(DEFAULT_SHAPES.values()));
    }

    private static final class ArrowShapeImpl
    extends AbstractVisualPropertyValue
    implements ArrowShape {
        public ArrowShapeImpl(String displayName, String serializableString) {
            super(displayName, serializableString);
        }

        @Override
        public boolean isFilled() {
            String str = this.getSerializableString();
            return str != null && !str.contains("OPEN");
        }
    }
}

