/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.view.model.table.CyColumnViewMetadata;
import org.cytoscape.view.model.table.CyRowViewMetadata;

public class CyTableViewMetadata {
    private final long savedTableSUID;
    private final String tableNamespace;
    private final String rendererID;
    private final Map<String, String> bypassValues;
    private final List<CyColumnViewMetadata> columnViews;
    private final List<CyRowViewMetadata> rowViews;
    private final Class<?> primaryKeyType;
    private final Class<?> primaryKeyListElementType;
    private CyTableMetadata underlyingTable;

    public CyTableViewMetadata(long savedTableSUID, String tableNamespace, String rendererID, Map<String, String> bypassValues, List<CyColumnViewMetadata> columnViews, List<CyRowViewMetadata> rowViews, Class<?> primaryKeyType, Class<?> primaryKeyListElementType) {
        this.savedTableSUID = savedTableSUID;
        this.rendererID = rendererID;
        this.columnViews = new ArrayList<CyColumnViewMetadata>(columnViews);
        this.bypassValues = bypassValues;
        this.tableNamespace = tableNamespace;
        this.rowViews = rowViews;
        this.primaryKeyType = primaryKeyType;
        this.primaryKeyListElementType = primaryKeyListElementType;
    }

    public long getSavedTableSUID() {
        return this.savedTableSUID;
    }

    public String getRendererID() {
        return this.rendererID;
    }

    public List<CyColumnViewMetadata> getColumnViews() {
        return Collections.unmodifiableList(this.columnViews);
    }

    public List<CyRowViewMetadata> getRowViews() {
        return Collections.unmodifiableList(this.rowViews);
    }

    public String getNamespace() {
        return this.tableNamespace;
    }

    public Map<String, String> getBypassValues() {
        return this.bypassValues;
    }

    public CyTableMetadata getUnderlyingTable() {
        return this.underlyingTable;
    }

    public void setUnderlyingTable(CyTableMetadata underlyingTable) {
        this.underlyingTable = underlyingTable;
    }

    public Class<?> getPrimaryKeyType() {
        return this.primaryKeyType;
    }

    public Class<?> getPrimaryKeyListElementType() {
        return this.primaryKeyListElementType;
    }
}

