/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.layout.EdgeWeighter;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPoint;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public final class LayoutPartition {
    private ArrayList<LayoutNode> nodeList;
    private ArrayList<LayoutEdge> edgeList;
    private Map<CyNode, LayoutNode> nodeToLayoutNode;
    private int nodeIndex = 0;
    private int partitionNumber = 0;
    private EdgeWeighter edgeWeighter = null;
    private double maxX = -100000.0;
    private double maxY = -100000.0;
    private double maxZ = -100000.0;
    private double minX = 100000.0;
    private double minY = 100000.0;
    private double minZ = 100000.0;
    private double width = 0.0;
    private double height = 0.0;
    private double depth = 0.0;
    private double averageX = 0.0;
    private double averageY = 0.0;
    private double averageZ = 0.0;
    private int lockedNodes = 0;
    private boolean dontMove = false;

    public LayoutPartition(int nodeCount, int edgeCount) {
        this.nodeList = new ArrayList(nodeCount);
        this.edgeList = new ArrayList(edgeCount);
        this.nodeToLayoutNode = new WeakHashMap<CyNode, LayoutNode>(nodeCount);
        this.partitionNumber = 1;
    }

    public LayoutPartition(CyNetworkView networkView, Collection<View<CyNode>> nodeSet, EdgeWeighter edgeWeighter) {
        this.initialize(networkView, nodeSet, edgeWeighter);
    }

    protected void dontMove(boolean dm) {
        this.dontMove = dm;
    }

    private void initialize(CyNetworkView networkView, Collection<View<CyNode>> nodeSet, EdgeWeighter edgeWeighter) {
        this.edgeWeighter = edgeWeighter;
        this.nodeList = new ArrayList(((CyNetwork)networkView.getModel()).getNodeCount());
        this.edgeList = new ArrayList(((CyNetwork)networkView.getModel()).getEdgeCount());
        this.nodeToLayoutNode = new WeakHashMap<CyNode, LayoutNode>(((CyNetwork)networkView.getModel()).getNodeCount());
        this.nodeListInitialize(networkView, nodeSet);
        this.edgeListInitialize(networkView);
        this.trimToSize();
        this.partitionNumber = 1;
    }

    public void setEdgeWeighter(EdgeWeighter edgeWeighter) {
        this.edgeWeighter = edgeWeighter;
    }

    protected void addNode(CyNetwork network, View<CyNode> nv, boolean locked) {
        CyNode node = nv.getModel();
        LayoutNode v = new LayoutNode(nv, this.nodeIndex++, network.getRow(node));
        this.nodeList.add(v);
        this.nodeToLayoutNode.put(node, v);
        if (locked) {
            v.lock();
            ++this.lockedNodes;
        } else {
            this.updateMinMax(nv.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION), nv.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION), nv.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION));
            this.width += nv.getVisualProperty(BasicVisualLexicon.NODE_WIDTH).doubleValue();
            this.height += nv.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT).doubleValue();
            this.depth += nv.getVisualProperty(BasicVisualLexicon.NODE_DEPTH).doubleValue();
        }
    }

    protected void addEdge(CyEdge edge, CyRow row) {
        LayoutEdge newEdge = new LayoutEdge(edge, row);
        this.updateWeights(newEdge);
        this.edgeList.add(newEdge);
    }

    protected void addEdge(CyEdge edge, LayoutNode v1, LayoutNode v2, CyRow row) {
        LayoutEdge newEdge = new LayoutEdge(edge, v1, v2, row);
        this.updateWeights(newEdge);
        this.edgeList.add(newEdge);
    }

    public void randomizeLocations(boolean is3D) {
        Date today = new Date();
        Random random = new Random(today.getTime());
        this.resetNodes();
        for (LayoutNode node : this.nodeList) {
            if (!node.isLocked()) {
                double x = random.nextDouble() * this.width;
                double y = random.nextDouble() * this.height;
                double z = is3D ? random.nextDouble() * this.depth : node.getZ();
                node.setLocation(x, y, z);
                this.updateMinMax(x, y, z);
                continue;
            }
            this.updateMinMax(node.getX(), node.getY(), node.getZ());
        }
    }

    public void randomizeLocations() {
        this.randomizeLocations(false);
    }

    public void moveNodeToLocation(LayoutNode node) {
        if (node.isLocked()) {
            return;
        }
        if (!this.dontMove) {
            node.moveToLocation();
        }
        this.updateMinMax(node.getX(), node.getY(), 0.0);
    }

    public void moveNodeToLocation3D(LayoutNode node) {
        if (node.isLocked()) {
            return;
        }
        if (!this.dontMove) {
            node.moveToLocation3D();
        }
        this.updateMinMax(node.getX(), node.getY(), node.getZ());
    }

    public void fixEdges() {
        for (LayoutEdge lEdge : this.edgeList) {
            CyEdge edge = lEdge.getEdge();
            CyNode target = edge.getTarget();
            CyNode source = edge.getSource();
            LayoutNode sourceLayoutNode = this.nodeToLayoutNode.get(source);
            LayoutNode targetLayoutNode = this.nodeToLayoutNode.get(target);
            if (sourceLayoutNode == null || targetLayoutNode == null) continue;
            lEdge.addNodes(sourceLayoutNode, targetLayoutNode);
        }
    }

    public void calculateEdgeWeights() {
        ListIterator<LayoutEdge> iter = this.edgeList.listIterator();
        while (iter.hasNext()) {
            LayoutEdge edge = iter.next();
            if (edge.getSource().isLocked() && edge.getTarget().isLocked()) {
                iter.remove();
                continue;
            }
            if (this.edgeWeighter == null || this.edgeWeighter.normalizeWeight(edge)) continue;
            iter.remove();
        }
    }

    public int size() {
        return this.nodeList.size();
    }

    public List<LayoutNode> getNodeList() {
        return this.nodeList;
    }

    public List<LayoutEdge> getEdgeList() {
        return this.edgeList;
    }

    public Iterator<LayoutNode> nodeIterator() {
        return this.nodeList.iterator();
    }

    public Iterator<LayoutEdge> edgeIterator() {
        return this.edgeList.iterator();
    }

    public int nodeCount() {
        return this.nodeList.size();
    }

    public int edgeCount() {
        return this.edgeList.size();
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public void setPartitionNumber(int part) {
        this.partitionNumber = part;
    }

    public int lockedNodeCount() {
        return this.lockedNodes;
    }

    public LayoutPoint getAverageLocation() {
        int nodes = this.nodeCount() - this.lockedNodes;
        return new LayoutPoint(this.averageX / (double)nodes, this.averageY / (double)nodes, this.averageZ / (double)nodes);
    }

    public void offset(double xoffset, double yoffset) {
        this.offset(xoffset, yoffset, 0.0);
    }

    public void offset(double xoffset, double yoffset, double zoffset) {
        double myMinX = this.minX;
        double myMinY = this.minY;
        double myMinZ = this.minZ;
        this.dontMove = false;
        this.resetNodes();
        for (LayoutNode node : this.nodeList) {
            node.increment(xoffset - myMinX, yoffset - myMinY, zoffset - myMinZ);
            this.moveNodeToLocation(node);
        }
    }

    public void resetNodes() {
        this.maxX = -100000.0;
        this.maxY = -100000.0;
        this.maxZ = -100000.0;
        this.minX = 100000.0;
        this.minY = 100000.0;
        this.minZ = 100000.0;
        this.averageX = 0.0;
        this.averageY = 0.0;
        this.averageZ = 0.0;
    }

    public double getArea() {
        return (this.maxX - this.minX) * (this.maxY - this.minY);
    }

    private void nodeListInitialize(CyNetworkView networkView, Collection<View<CyNode>> nodeSet) {
        this.nodeList = new ArrayList(((CyNetwork)networkView.getModel()).getNodeCount());
        for (View<CyNode> nv : networkView.getNodeViews()) {
            if (!nodeSet.contains(nv)) {
                this.addNode((CyNetwork)networkView.getModel(), nv, true);
                continue;
            }
            this.addNode((CyNetwork)networkView.getModel(), nv, false);
        }
    }

    private void edgeListInitialize(CyNetworkView networkView) {
        for (View<CyEdge> ev : networkView.getEdgeViews()) {
            CyNode target;
            CyEdge edge = ev.getModel();
            CyNode source = edge.getSource();
            if (source == (target = edge.getTarget())) continue;
            LayoutNode v1 = this.nodeToLayoutNode.get(source);
            LayoutNode v2 = this.nodeToLayoutNode.get(target);
            if (v1.isLocked() && v2.isLocked()) continue;
            this.addEdge(edge, v1, v2, ((CyNetwork)networkView.getModel()).getRow(edge));
        }
    }

    void trimToSize() {
        this.nodeList.trimToSize();
        this.edgeList.trimToSize();
    }

    private void updateMinMax(double x, double y, double z) {
        this.minX = Math.min(this.minX, x);
        this.minY = Math.min(this.minY, y);
        this.minZ = Math.min(this.minZ, z);
        this.maxX = Math.max(this.maxX, x);
        this.maxY = Math.max(this.maxY, y);
        this.maxZ = Math.max(this.maxZ, z);
        this.averageX += x;
        this.averageY += y;
        this.averageZ += z;
        this.width = this.maxX - this.minX;
        this.height = this.maxY - this.minY;
        this.depth = this.maxZ - this.minZ;
    }

    private void updateWeights(LayoutEdge newEdge) {
        if (this.edgeWeighter != null) {
            this.edgeWeighter.setWeight(newEdge);
        }
    }
}

