/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.layout.LayoutNode;

public final class LayoutEdge
implements Comparable<LayoutEdge> {
    private LayoutNode v1;
    private LayoutNode v2;
    private double weight = 0.5;
    private double logWeight;
    private CyEdge edge;
    private CyRow row;

    public LayoutEdge(CyEdge edge, CyRow row) {
        this.edge = edge;
        this.row = row;
    }

    public LayoutEdge(CyEdge edge, LayoutNode v1, LayoutNode v2, CyRow row) {
        this.edge = edge;
        this.v1 = v1;
        this.v2 = v2;
        this.row = row;
        if (v1 != v2) {
            v1.addNeighbor(v2);
            v2.addNeighbor(v1);
        }
    }

    public void addNodes(LayoutNode v1, LayoutNode v2) {
        this.v1 = v1;
        this.v2 = v2;
        if (v1 != v2) {
            v1.addNeighbor(v2);
            v2.addNeighbor(v1);
        }
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setLogWeight(double logWeight) {
        this.logWeight = logWeight;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getLogWeight() {
        return this.logWeight;
    }

    public LayoutNode getSource() {
        return this.v1;
    }

    public LayoutNode getTarget() {
        return this.v2;
    }

    public CyEdge getEdge() {
        return this.edge;
    }

    public CyRow getRow() {
        return this.row;
    }

    public String getIdentifier() {
        return this.edge.getSUID().toString();
    }

    public String toString() {
        String source = "undefined";
        String target = "undefined";
        String edgeId = "undefined";
        if (this.v1 != null) {
            source = this.v1.getIdentifier();
        }
        if (this.v2 != null) {
            target = this.v2.getIdentifier();
        }
        if (this.edge != null) {
            edgeId = this.getIdentifier();
        }
        return "Edge " + edgeId + " connecting " + source + " and " + target + " with weight " + this.weight;
    }

    @Override
    public int compareTo(LayoutEdge edgeView) {
        return this.getIdentifier().compareTo(edgeView.getIdentifier());
    }
}

