/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.undo.UndoSupport;

public abstract class AbstractLayoutAlgorithm
implements CyLayoutAlgorithm {
    private final String humanName;
    private final String computerName;
    private Object defaultContext;
    protected final UndoSupport undoSupport;

    public AbstractLayoutAlgorithm(String computerName, String humanName, UndoSupport undoSupport) {
        this.computerName = computerName;
        this.humanName = humanName;
        this.undoSupport = undoSupport;
    }

    @Override
    public Object createLayoutContext() {
        return new Object();
    }

    @Override
    public final Object getDefaultLayoutContext() {
        if (this.defaultContext == null) {
            this.defaultContext = this.createLayoutContext();
        }
        return this.defaultContext;
    }

    @Override
    public String getName() {
        return this.computerName;
    }

    @Override
    public String toString() {
        return this.humanName;
    }

    @Override
    public Set<Class<?>> getSupportedNodeAttributeTypes() {
        return new HashSet();
    }

    @Override
    public Set<Class<?>> getSupportedEdgeAttributeTypes() {
        return new HashSet();
    }

    @Override
    public boolean getSupportsSelectedOnly() {
        return false;
    }

    @Override
    public boolean isReady(CyNetworkView view, Object tunableContext, Set<View<CyNode>> nodesToLayout, String attributeName) {
        if (view == null || nodesToLayout == null) {
            return false;
        }
        if (nodesToLayout.size() == 0 && view.getNodeViews().size() == 0) {
            return false;
        }
        if (tunableContext instanceof TunableValidator) {
            StringBuilder errors = new StringBuilder();
            return ((TunableValidator)tunableContext).getValidationState(errors) == TunableValidator.ValidationState.OK;
        }
        return true;
    }
}

