/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.cytoscape.util.swing.GravityTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuGravityTracker
implements GravityTracker {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final JMenu menu;
    private final Map<Component, Double> componentGravity;

    public MenuGravityTracker(JMenu menu) {
        this.menu = menu;
        this.componentGravity = new HashMap<Component, Double>();
    }

    @Override
    public JMenu getMenu() {
        return this.menu;
    }

    @Override
    public void addMenuItem(JMenuItem newMenuItem, double gravity) {
        int index = this.getInsertLocation(newMenuItem.getText(), gravity);
        this.menu.insert(newMenuItem, index);
        this.componentGravity.put(newMenuItem, gravity);
        logger.debug("Inserted menu item: " + newMenuItem + " with gravity: " + gravity);
    }

    @Override
    public void addMenu(JMenu newSubmenu, double gravity) {
        int index = this.getInsertLocation(newSubmenu.getText(), gravity);
        this.menu.insert(newSubmenu, index);
        this.componentGravity.put(newSubmenu, gravity);
        logger.debug("Inserted menu: " + newSubmenu + " with gravity: " + gravity);
    }

    @Override
    public void addMenuSeparator(double gravity) {
        int index = this.getInsertLocation("-", gravity);
        this.menu.insertSeparator(index);
        Component separator = this.menu.getMenuComponent(index);
        this.componentGravity.put(separator, gravity);
        logger.debug("Inserted menu separator with gravity: " + gravity);
    }

    @Override
    public void removeComponent(Component component) {
        if (this.componentGravity.remove(component) != null) {
            this.menu.remove(component);
        }
    }

    private int getInsertLocation(String newMenuText, double newGravity) {
        if (newGravity == -1.0) {
            for (int i = 0; i < this.menu.getMenuComponentCount(); ++i) {
                JMenuItem menuItem;
                JMenu subMenu;
                Component item = this.menu.getMenuComponent(i);
                if (!(item instanceof JMenu ? newMenuText.compareToIgnoreCase((subMenu = (JMenu)item).getText()) < 0 : item instanceof JMenuItem && newMenuText.compareToIgnoreCase((menuItem = (JMenuItem)item).getText()) < 0)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.menu.getMenuComponentCount(); ++i) {
                Component item = this.menu.getMenuComponent(i);
                Double gravity = this.componentGravity.get(item);
                if (gravity == null || !(newGravity < gravity)) continue;
                return i;
            }
        }
        return this.menu.getMenuComponentCount();
    }
}

