/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ToolTipUI;

public final class CyToolTip
extends JToolTip {
    private final JComponent comp;
    private final String desc;
    private final String longDesc;
    private final Icon icon;

    public CyToolTip(JComponent comp, String desc, String longDesc, Icon icon) {
        this.comp = comp;
        this.desc = desc;
        this.longDesc = longDesc;
        this.icon = icon;
        this.setComponent(comp);
        this.setUI(new ToolTipUI(){

            @Override
            public Dimension getMinimumSize(JComponent c) {
                return c.getLayout().minimumLayoutSize(c);
            }

            @Override
            public Dimension getPreferredSize(JComponent c) {
                return c.getLayout().preferredLayoutSize(c);
            }

            @Override
            public Dimension getMaximumSize(JComponent c) {
                return this.getPreferredSize(c);
            }
        });
        if (desc != null || longDesc != null || icon != null) {
            this.init();
        }
        if (longDesc != null || icon != null) {
            this.increaseDismissDelay();
        }
    }

    private void init() {
        JLabel lbl;
        Color bg = new Color(UIManager.getColor("Table.foreground").getRGB());
        Color fg = new Color(UIManager.getColor("Table.background").getRGB());
        JPanel content = new JPanel();
        content.setBackground(bg);
        int w = this.icon != null ? this.icon.getIconWidth() : 0;
        GroupLayout layout = new GroupLayout(content);
        content.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(this.icon != null ? GroupLayout.Alignment.CENTER : GroupLayout.Alignment.LEADING, true);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(2).addGroup(hGroup).addGap(2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(this.icon != null ? 2 : 4).addGroup(vGroup).addGap(4));
        if (this.icon != null) {
            if (this.icon.getIconWidth() > 20) {
                w = this.icon.getIconWidth();
            }
            lbl = new JLabel(this.icon);
            if (this.icon instanceof ImageIcon) {
                ((ImageIcon)this.icon).setImageObserver(lbl);
            }
            this.addComponent(lbl, hGroup, vGroup, w);
        }
        if (this.desc != null) {
            lbl = new JLabel(this.desc);
            lbl.setFont(lbl.getFont().deriveFont(1));
            lbl.setForeground(fg);
            this.addComponent(lbl, hGroup, vGroup, w);
        }
        if (this.longDesc != null && !this.longDesc.equalsIgnoreCase(this.desc)) {
            JTextArea ta = new JTextArea(this.longDesc);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            ta.setEditable(false);
            ta.setForeground(fg);
            ta.setBackground(bg);
            JScrollPane sp = new JScrollPane(ta);
            sp.setHorizontalScrollBarPolicy(31);
            sp.setVerticalScrollBarPolicy(21);
            sp.setBackground(bg);
            sp.getViewport().setBackground(bg);
            sp.setBorder(BorderFactory.createEmptyBorder());
            this.addComponent(sp, hGroup, vGroup, w);
        }
        this.adjustSize(content);
        this.setLayout(new BorderLayout());
        this.add((Component)content, "Center");
    }

    private void addComponent(JComponent c, GroupLayout.ParallelGroup hGroup, GroupLayout.SequentialGroup vGroup, int w) {
        if (w <= 0) {
            hGroup.addComponent(c, -1, -1, Short.MAX_VALUE);
        } else {
            hGroup.addComponent(c, w, w, w);
        }
        vGroup.addComponent(c, -2, -1, -2);
    }

    private void increaseDismissDelay() {
        this.comp.addMouseListener(new MouseAdapter(){
            final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
            final int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(1L);

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
            }
        });
    }

    private void adjustSize(JPanel content) {
        Window window = new Window(null);
        window.add(content);
        window.pack();
        for (Component c : content.getComponents()) {
            if (!(c instanceof JScrollPane)) continue;
            JViewport viewport = ((JScrollPane)c).getViewport();
            c.setMinimumSize(viewport.getPreferredSize());
            c.setPreferredSize(viewport.getPreferredSize());
        }
        window.removeAll();
        window.dispose();
    }
}

