/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class BasicCollapsiblePanel
extends JPanel {
    private static final long serialVersionUID = 2010434345567315524L;
    private final Vector<CollapseListener> collapseListeners = new Vector();
    private Border border = LookAndFeelUtil.createPanelBorder();
    AbstractButton titleComponent;
    private JButton arrowBtn;
    private JPanel contentPane;
    private boolean collapsed;

    public BasicCollapsiblePanel(JRadioButton component) {
        this(component, !component.isSelected());
        component.addItemListener(new ExpandAndCollapseAction());
        this.setCollapsed(this.collapsed);
    }

    public BasicCollapsiblePanel(String text) {
        this((AbstractButton)null, true);
        this.getArrowBtn().setText(text);
        this.setCollapsed(this.collapsed);
    }

    private BasicCollapsiblePanel(AbstractButton titleComponent, boolean collapsed) {
        this.titleComponent = titleComponent != null ? titleComponent : this.getArrowBtn();
        this.collapsed = collapsed;
        this.setLayout(new BorderLayout());
        super.add((Component)this.titleComponent, "North");
        super.add((Component)this.getContentPane(), "Center");
    }

    public void setTitleComponentText(String text) {
        if (this.titleComponent instanceof JButton) {
            this.titleComponent.setText(text);
        }
    }

    public JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BoxLayout(this.contentPane, 3));
            this.contentPane.setBorder(this.border);
            if (LookAndFeelUtil.isAquaLAF()) {
                this.contentPane.setOpaque(false);
            }
        }
        return this.contentPane;
    }

    @Override
    public Component add(Component comp) {
        this.adjust(comp);
        return this.contentPane.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        this.adjust(comp);
        return this.contentPane.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.adjust(comp);
        this.contentPane.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.adjust(comp);
        this.contentPane.add(comp, constraints, index);
    }

    @Override
    public Component add(String name, Component comp) {
        this.adjust(comp);
        return this.contentPane.add(name, comp);
    }

    public void setCollapsed(boolean collapse) {
        if (collapse) {
            this.getContentPane().setVisible(false);
            this.getArrowBtn().setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        } else {
            this.getContentPane().setVisible(true);
            this.getArrowBtn().setIcon(UIManager.getIcon("Tree.expandedIcon"));
        }
        this.collapsed = collapse;
        this.updateUI();
        if (this.collapseListeners != null) {
            for (CollapseListener listener : this.collapseListeners) {
                if (collapse) {
                    listener.collapsed();
                    continue;
                }
                listener.expanded();
            }
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.titleComponent.setToolTipText(text);
    }

    public void addCollapseListener(CollapseListener listener) {
        this.collapseListeners.add(listener);
    }

    public boolean removeCollapeListener(CollapseListener listener) {
        return this.collapseListeners.remove(listener);
    }

    private JButton getArrowBtn() {
        if (this.arrowBtn == null) {
            Color color;
            this.arrowBtn = new JButton("", UIManager.getIcon("Tree.collapsedIcon"));
            if (LookAndFeelUtil.isWinLAF()) {
                this.arrowBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            } else {
                this.arrowBtn.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            }
            this.arrowBtn.setMargin(new Insets(0, 0, 3, 0));
            this.arrowBtn.setContentAreaFilled(false);
            this.arrowBtn.setFocusable(false);
            this.arrowBtn.setHorizontalAlignment(2);
            this.arrowBtn.setHorizontalTextPosition(4);
            this.arrowBtn.setVerticalAlignment(0);
            this.arrowBtn.setVerticalTextPosition(0);
            Font font = BorderFactory.createTitledBorder(this.border, "Sample").getTitleFont();
            if (font == null) {
                font = UIManager.getFont("Label.font");
            }
            if ((color = BorderFactory.createTitledBorder(this.border, "Sample").getTitleColor()) == null) {
                color = UIManager.getColor("Label.foreground");
            }
            if (font != null) {
                if (LookAndFeelUtil.isAquaLAF()) {
                    font = font.deriveFont(LookAndFeelUtil.getSmallFontSize());
                }
                this.arrowBtn.setFont(font);
            }
            if (LookAndFeelUtil.isNimbusLAF()) {
                this.arrowBtn.setFont(this.arrowBtn.getFont().deriveFont(1));
            }
            if (color != null) {
                this.arrowBtn.setForeground(color);
            }
            this.arrowBtn.addActionListener(new ExpandAndCollapseAction());
        }
        return this.arrowBtn;
    }

    private void adjust(Component c) {
        if (LookAndFeelUtil.isAquaLAF() && c instanceof JPanel) {
            ((JPanel)c).setOpaque(false);
        }
    }

    private final class ExpandAndCollapseAction
    extends AbstractAction
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = 2010434345567315525L;

        private ExpandAndCollapseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicCollapsiblePanel.this.setCollapsed(!BasicCollapsiblePanel.this.isCollapsed());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            BasicCollapsiblePanel.this.setCollapsed(!BasicCollapsiblePanel.this.isCollapsed());
        }
    }

    public static interface CollapseListener
    extends EventListener {
        public void collapsed();

        public void expanded();
    }
}

