/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.session;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableMetadata;
import org.cytoscape.property.CyProperty;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.table.CyTableViewMetadata;
import org.cytoscape.view.vizmap.VisualStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CySession {
    private final Set<CyNetwork> networks;
    private final Set<CyNetworkView> netViews;
    private final Set<CyTableMetadata> tables;
    private final Set<CyTableViewMetadata> tableViews;
    private final Map<CyNetworkView, String> vsMap;
    private final Set<CyProperty<?>> properties;
    private final Set<VisualStyle> visualStyles;
    private final Set<VisualStyle> tableStyles;
    private final Map<String, List<File>> appFiles;
    private final Map<Class<? extends CyIdentifiable>, Map<Object, ? extends CyIdentifiable>> objectMap;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    private CySession(Builder b) {
        this.networks = Collections.unmodifiableSet(b.networks == null ? new HashSet() : b.networks);
        this.netViews = Collections.unmodifiableSet(b.netViews == null ? new HashSet() : b.netViews);
        this.tableViews = Collections.unmodifiableSet(b.tableViews == null ? new HashSet() : b.tableViews);
        this.tables = Collections.unmodifiableSet(b.tables == null ? new HashSet() : b.tables);
        this.vsMap = Collections.unmodifiableMap(b.vsMap == null ? new WeakHashMap() : b.vsMap);
        this.properties = Collections.unmodifiableSet(b.properties == null ? new HashSet() : b.properties);
        this.visualStyles = Collections.unmodifiableSet(b.visualStyles == null ? new HashSet() : b.visualStyles);
        this.tableStyles = Collections.unmodifiableSet(b.tableStyles == null ? new HashSet() : b.tableStyles);
        this.appFiles = Collections.unmodifiableMap(b.appFiles == null ? new HashMap() : b.appFiles);
        this.objectMap = Collections.unmodifiableMap(b.objectMap == null ? new HashMap() : b.objectMap);
    }

    public Set<CyNetwork> getNetworks() {
        return this.networks;
    }

    public Set<CyNetworkView> getNetworkViews() {
        return this.netViews;
    }

    public Set<CyTableViewMetadata> getTableViews() {
        return this.tableViews;
    }

    public Set<CyTableMetadata> getTables() {
        return this.tables;
    }

    public Map<CyNetworkView, String> getViewVisualStyleMap() {
        return this.vsMap;
    }

    public Set<CyProperty<?>> getProperties() {
        return this.properties;
    }

    public Set<VisualStyle> getVisualStyles() {
        return this.visualStyles;
    }

    public Set<VisualStyle> getTableStyles() {
        return this.tableStyles;
    }

    public Map<String, List<File>> getAppFileListMap() {
        return this.appFiles;
    }

    public <T extends CyIdentifiable> T getObject(Long oldSUID, Class<T> type) {
        return this.getObjectInternal(oldSUID, type);
    }

    public <T extends CyIdentifiable> T getObject(String oldId, Class<T> type) {
        return this.getObjectInternal(oldId, type);
    }

    private <T extends CyIdentifiable> T getObjectInternal(Object oldId, Class<T> type) {
        CyIdentifiable tableEntry = null;
        Map<Object, ? extends CyIdentifiable> objByIdMap = this.objectMap.get(type);
        if (objByIdMap != null) {
            CyIdentifiable obj = objByIdMap.get(oldId);
            try {
                tableEntry = (CyIdentifiable)type.cast(obj);
            }
            catch (ClassCastException cce) {
                logger.error("ClassCastException: Tried to cast object " + obj + " to " + type + " (old id = " + oldId + ")");
            }
        }
        return (T)tableEntry;
    }

    public static class Builder {
        private Set<CyNetwork> networks;
        private Set<CyNetworkView> netViews;
        private Set<CyTableMetadata> tables;
        private Set<CyTableViewMetadata> tableViews;
        private Map<CyNetworkView, String> vsMap;
        private Set<CyProperty<?>> properties;
        private Set<VisualStyle> visualStyles;
        private Set<VisualStyle> tableStyles;
        private Map<String, List<File>> appFiles;
        private Map<Class<? extends CyIdentifiable>, Map<Object, ? extends CyIdentifiable>> objectMap;

        public CySession build() {
            return new CySession(this);
        }

        public Builder networks(Set<CyNetwork> networks) {
            this.networks = networks;
            return this;
        }

        public Builder networkViews(Set<CyNetworkView> views) {
            this.netViews = views;
            return this;
        }

        public Builder tableViews(Set<CyTableViewMetadata> views) {
            this.tableViews = views;
            return this;
        }

        public Builder tables(Set<CyTableMetadata> tables2) {
            this.tables = tables2;
            return this;
        }

        public Builder viewVisualStyleMap(Map<CyNetworkView, String> vs) {
            this.vsMap = vs;
            return this;
        }

        public Builder properties(Set<CyProperty<?>> p) {
            this.properties = p;
            return this;
        }

        public Builder visualStyles(Set<VisualStyle> styles) {
            this.visualStyles = styles;
            return this;
        }

        public Builder tableStyles(Set<VisualStyle> styles) {
            this.tableStyles = styles;
            return this;
        }

        public Builder appFileListMap(Map<String, List<File>> p) {
            this.appFiles = p;
            return this;
        }

        public Builder objectMap(Map<Class<? extends CyIdentifiable>, Map<Object, ? extends CyIdentifiable>> map) {
            this.objectMap = map;
            return this;
        }
    }
}

