/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.cytoscape.property.CyProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigDirPropsReader
implements CyProperty<Properties> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected final String name;
    protected final Properties props;
    protected final CyProperty.SavePolicy savePolicy;

    public AbstractConfigDirPropsReader(String name, String propFileName, CyProperty.SavePolicy savePolicy) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (propFileName == null) {
            throw new NullPointerException("propFileName cannot be null");
        }
        if (savePolicy == null) {
            throw new NullPointerException("savePolicy cannot be null");
        }
        if (savePolicy != CyProperty.SavePolicy.CONFIG_DIR && savePolicy != CyProperty.SavePolicy.SESSION_FILE_AND_CONFIG_DIR) {
            throw new IllegalArgumentException("Save policy must be either CONFIG_DIR or SESSION_FILE_AND_CONFIG_DIR");
        }
        this.name = name;
        this.savePolicy = savePolicy;
        this.props = new Properties();
        try {
            this.readDefaultFromJar(propFileName);
            this.readLocalModifications(propFileName);
        }
        catch (Exception e) {
            logger.warn("Error reading properties file '" + propFileName + "' - using empty intance.", (Throwable)e);
            this.props.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLocalModifications(String propFileName) throws Exception {
        InputStream is = null;
        try {
            File configDir = new File(System.getProperty("user.home"), "CytoscapeConfiguration");
            File localPropsFile = new File(configDir, propFileName);
            if (localPropsFile.exists()) {
                is = new FileInputStream(localPropsFile);
                this.props.load(is);
                is.close();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                is = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDefaultFromJar(String propFileName) throws Exception {
        InputStream is = null;
        try {
            Object fileName = !propFileName.startsWith("/") ? "/" + propFileName : propFileName;
            is = this.getClass().getResourceAsStream((String)fileName);
            if (is != null) {
                this.props.load(is);
            } else {
                logger.debug("couldn't find resource '" + propFileName + "' in jar.");
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                is = null;
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CyProperty.SavePolicy getSavePolicy() {
        return this.savePolicy;
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public Class<? extends Properties> getPropertyType() {
        return Properties.class;
    }
}

