/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.events;

import org.cytoscape.event.AbstractCyEvent;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnNameChangedListener;

public final class ColumnNameChangedEvent
extends AbstractCyEvent<CyTable> {
    private final String oldColumnName;
    private final String newColumnName;

    public ColumnNameChangedEvent(CyTable source, String oldColumnName, String newColumnName) {
        super(source, ColumnNameChangedListener.class);
        if (oldColumnName == null) {
            throw new NullPointerException("\"oldColumnName\" must not be null.");
        }
        this.oldColumnName = oldColumnName;
        if (newColumnName == null) {
            throw new NullPointerException("\"newColumnName\" must not be null.");
        }
        this.newColumnName = newColumnName;
    }

    public String getOldColumnName() {
        return this.oldColumnName;
    }

    public String getOldNamespace() {
        return CyColumn.splitColumnName(this.oldColumnName)[0];
    }

    public String getOldNameOnly() {
        return CyColumn.splitColumnName(this.oldColumnName)[1];
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public String getNewNamespace() {
        return CyColumn.splitColumnName(this.newColumnName)[0];
    }

    public String getNewNameOnly() {
        return CyColumn.splitColumnName(this.newColumnName)[1];
    }
}

