/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs;

import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.cytoscape.jobs.CyJobData;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualProperty;

public interface CyJobDataService {
    public String getServiceName();

    public CyJobData getDataInstance();

    public CyJobData addData(CyJobData var1, String var2, Map<Object, Object> var3);

    public CyJobData addData(CyJobData var1, String var2, Object var3);

    default public CyJobData addData(CyJobData data, String key, CyNetwork network, List<? extends CyIdentifiable> nodesAndEdges, List<String> nodeColumns, List<String> edgeColumns) {
        throw new UnsupportedOperationException("This data service doesn't support network data");
    }

    default public CyJobData addData(CyJobData data, String key, CyTable table, List<CyRow> rows, List<String> columns) {
        throw new UnsupportedOperationException("This data service doesn't support table data");
    }

    default public CyJobData addData(CyJobData data, String key, CyNetworkView networkView, List<? extends CyIdentifiable> nodesAndEdges, List<VisualProperty<?>> properties) {
        throw new UnsupportedOperationException("This data service doesn't support network view data");
    }

    public Object getData(CyJobData var1, String var2);

    public Map<Object, Object> getMapData(CyJobData var1, String var2);

    default public CyNetwork getNetworkData(CyJobData data, String key) {
        throw new UnsupportedOperationException("This data service doesn't support network data");
    }

    default public CyTable getTableData(CyJobData data, String key) {
        throw new UnsupportedOperationException("This data service doesn't support table data");
    }

    default public CyNetworkView getViewData(CyJobData data, String key) {
        throw new UnsupportedOperationException("This data service doesn't support network view data");
    }

    public Object getSerializedData(CyJobData var1);

    public CyJobData deserialize(Object var1);

    public CyJobData deserialize(Reader var1);

    public CyJobData deserialize(InputStream var1);
}

