/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.List;

public final class IdentDescriptor {
    private final Class type;
    private final Object value;

    public IdentDescriptor(Object o) {
        if (o == null) {
            throw new NullPointerException("argument must not be null.");
        }
        if (o.getClass() == Integer.class) {
            Integer i = (Integer)o;
            this.type = Long.class;
            this.value = new Long(i.intValue());
            return;
        }
        if (o instanceof List) {
            this.type = List.class;
        } else {
            if (o.getClass() != Long.class && o.getClass() != Double.class && o.getClass() != Boolean.class && o.getClass() != String.class) {
                throw new IllegalArgumentException("argument is of an unsupported type (" + o.getClass() + ").");
            }
            this.type = o.getClass();
        }
        this.value = o;
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }
}

