/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.command;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.cytoscape.command.StringTunableHandler;
import org.cytoscape.work.AbstractTunableHandler;
import org.cytoscape.work.Tunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringTunableHandler
extends AbstractTunableHandler
implements StringTunableHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String QUOTE = "\"";

    public AbstractStringTunableHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
    }

    public AbstractStringTunableHandler(Method get, Method set, Object o, Tunable t) {
        super(get, set, o, t);
    }

    @Override
    public void processArgString(String s) {
        try {
            if (s == null) {
                return;
            }
            String[] args = s.split(SPACE);
            for (int i = 0; i < args.length; ++i) {
                Object result;
                String arg = args[i];
                if (arg.isEmpty()) continue;
                String[] keyValue = arg.split(EQUALS);
                if (keyValue.length != 2) {
                    logger.warn("couldn't parse 'key=value' string from arg: '" + arg + "'");
                    continue;
                }
                String key = keyValue[0];
                Object value = keyValue[1];
                if (((String)value).startsWith(QUOTE)) {
                    while (((String)value).startsWith(QUOTE) && !((String)value).endsWith(QUOTE)) {
                        value = (String)value + SPACE + args[++i];
                    }
                    value = ((String)value).substring(1, ((String)value).length() - 1);
                }
                if (!key.equals(this.getName())) continue;
                try {
                    result = this.processArg((String)value);
                }
                catch (Exception e) {
                    logger.warn("Couldn't parse value from: " + (String)value, (Throwable)e);
                    return;
                }
                this.setValue(result);
                return;
            }
            logger.debug("found no match for tunable: " + this.getQualifiedName());
        }
        catch (Exception e) {
            logger.warn("tunable handler exception: " + this.getQualifiedName(), (Throwable)e);
        }
    }

    @Override
    public abstract Object processArg(String var1) throws Exception;

    @Override
    public final void handle() {
    }
}

