/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing;

import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.cytoscape.application.swing.CyColumnPresentation;
import org.cytoscape.model.CyColumn;
import org.cytoscape.util.swing.IconManager;

public interface CyColumnPresentationManager {
    public CyColumnPresentation getColumnPresentation(String var1);

    default public void setLabel(String columnName, JLabel label) {
        this.setLabel(columnName, label::setIcon, label::setText);
    }

    default public void setLabel(String columnName, Consumer<Icon> setIcon, Consumer<String> setText) {
        String[] parts = CyColumn.splitColumnName(columnName);
        String namespace = parts[0];
        String name = parts[1];
        CyColumnPresentation pres = this.getColumnPresentation(namespace);
        Icon icon = pres.getNamespaceIcon();
        if (icon != null && setIcon != null) {
            setIcon.accept(IconManager.resizeIcon(icon, 16));
        }
        if (setText != null) {
            setText.accept(name);
        }
    }
}

