/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AcceleratorParser {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String PREFIX = "VK_";
    private static final String FUNCTION_KEY = "fn";
    private static final Map<String, Integer> MOD_MAP = new HashMap<String, Integer>();

    AcceleratorParser() {
    }

    static KeyStroke parse(String string) {
        if (string.startsWith(FUNCTION_KEY)) {
            return KeyStroke.getKeyStroke(MOD_MAP.get(string), 0);
        }
        int keyCode = 0;
        int modifierCode = 0;
        StringTokenizer tokenizer = new StringTokenizer(string);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                modifierCode |= AcceleratorParser.lookupModifier(token);
                continue;
            }
            keyCode = AcceleratorParser.lookupVKCode(token);
        }
        if (keyCode == 0) {
            return null;
        }
        return KeyStroke.getKeyStroke(keyCode, modifierCode);
    }

    private static int lookupModifier(String mod) {
        Integer modifier = MOD_MAP.get(mod.toLowerCase());
        if (modifier == null) {
            logger.warn("The modifier '" + mod + "' is invalid; valid modifiers are: " + MOD_MAP.keySet().toString());
            return 0;
        }
        return modifier;
    }

    private static int lookupVKCode(String name) {
        Object newName = name.toUpperCase();
        if (!((String)newName).startsWith(PREFIX)) {
            newName = PREFIX + (String)newName;
        }
        String error = "The virtual key '" + (String)newName + "' does not exist.";
        int code = 0;
        try {
            code = KeyEvent.class.getField((String)newName).getInt(KeyEvent.class);
        }
        catch (NoSuchFieldException ex) {
            code = 0;
            logger.warn(error);
        }
        catch (IllegalAccessException ex) {
            code = 0;
            logger.warn(error);
        }
        return code;
    }

    static {
        MOD_MAP.put("command", Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        MOD_MAP.put("cmd", Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        MOD_MAP.put("meta", Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        MOD_MAP.put("control", Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        MOD_MAP.put("ctrl", Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        MOD_MAP.put("shift", 64);
        MOD_MAP.put("alt", 512);
        MOD_MAP.put("option", 512);
        MOD_MAP.put("opt", 512);
        MOD_MAP.put("fn1", 112);
        MOD_MAP.put("fn2", 113);
        MOD_MAP.put("fn3", 114);
        MOD_MAP.put("fn4", 115);
        MOD_MAP.put("fn5", 116);
        MOD_MAP.put("fn6", 117);
        MOD_MAP.put("fn7", 118);
        MOD_MAP.put("fn8", 119);
        MOD_MAP.put("fn9", 120);
        MOD_MAP.put("fn10", 121);
    }
}

