/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.PopupMenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractEnableSupport;
import org.cytoscape.application.swing.AcceleratorParser;
import org.cytoscape.application.swing.ActionEnableSupport;
import org.cytoscape.application.swing.AlwaysEnabledEnableSupport;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.TaskFactoryEnableSupport;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCyAction
extends AbstractAction
implements CyAction {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected String preferredMenu;
    protected float menuGravity = 100.0f;
    protected float toolbarGravity = -1.0f;
    protected boolean acceleratorSet;
    protected KeyStroke acceleratorKeyStroke;
    protected boolean useCheckBoxMenuItem;
    protected boolean useToggleButton;
    protected boolean inToolBar;
    protected boolean inNodeTableToolBar;
    protected boolean inEdgeTableToolBar;
    protected boolean inNetworkTableToolBar;
    protected boolean inUnassignedTableToolBar;
    protected boolean inMenuBar = true;
    protected boolean insertSeparatorBefore;
    protected boolean insertSeparatorAfter;
    protected boolean insertToolbarSeparatorBefore;
    protected boolean insertToolbarSeparatorAfter;
    protected String name;
    protected URL toolTipImage;
    protected Map<String, String> configurationProperties;
    private final AbstractEnableSupport enabler;

    public AbstractCyAction(String name) {
        super(name);
        this.enabler = new AlwaysEnabledEnableSupport(this);
        this.addNameChangeListener();
    }

    private void addNameChangeListener() {
        this.name = (String)this.getValue("Name");
        this.addPropertyChangeListener(evt -> {
            if (!"Name".equals(evt.getPropertyName())) {
                return;
            }
            this.name = (String)evt.getNewValue();
        });
    }

    public AbstractCyAction(String name, CyApplicationManager applicationManager, String enableFor, CyNetworkViewManager networkViewManager) {
        super(name);
        this.enabler = new ActionEnableSupport(this, enableFor, applicationManager, networkViewManager);
        this.addNameChangeListener();
    }

    public AbstractCyAction(Map<String, String> configProps, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager) {
        this(configProps.get("title"), applicationManager, configProps.get("enableFor"), networkViewManager);
        this.configFromProps(configProps);
        this.addNameChangeListener();
    }

    public AbstractCyAction(Map<String, String> configProps, TaskFactory predicate) {
        super(configProps.get("title"));
        this.enabler = new TaskFactoryEnableSupport(this, predicate);
        this.configFromProps(configProps);
        this.addNameChangeListener();
    }

    public AbstractCyAction(Map<String, String> configProps, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager, TaskFactory factory) {
        super(configProps.get("title"));
        String enableFor = configProps.get("enableFor");
        if (enableFor == null) {
            this.enabler = new TaskFactoryEnableSupport(this, factory);
        } else {
            TaskFactoryEnableSupport taskFactoryEnabler = new TaskFactoryEnableSupport((Action)null, factory);
            ActionEnableSupport actionEnabler = new ActionEnableSupport((Action)null, enableFor, applicationManager, networkViewManager);
            this.enabler = new ConjunctionEnableSupport(this, actionEnabler, taskFactoryEnabler);
        }
        this.configFromProps(configProps);
        this.addNameChangeListener();
    }

    private void configFromProps(Map<String, String> props) {
        String toolbarGravityString;
        String menuGravityString;
        KeyStroke command;
        String keyComboString;
        String prefMenu;
        URL tooltipImg;
        String tooltipDesc;
        String tooltip;
        URL smallIconURL;
        this.configurationProperties = props;
        URL largeIconURL = this.getURL(props.get("largeIconURL"));
        if (largeIconURL != null) {
            this.putValue("SwingLargeIconKey", new ImageIcon(largeIconURL));
        }
        if ((smallIconURL = this.getURL(props.get("smallIconURL"))) != null) {
            this.putValue("SmallIcon", new ImageIcon(smallIconURL));
        }
        if ((tooltip = props.get("tooltip")) != null) {
            this.putValue("ShortDescription", tooltip);
        }
        if ((tooltipDesc = props.get("tooltipLongDescription")) != null) {
            this.putValue("LongDescription", tooltipDesc);
        }
        if ((tooltipImg = this.getURL(props.get("tooltipImage"))) != null) {
            this.toolTipImage = tooltipImg;
        }
        if (AbstractCyAction.isTrue(props.get("inToolBar"))) {
            this.inToolBar = true;
        }
        if ((prefMenu = props.get("preferredMenu")) != null) {
            this.setPreferredMenu(prefMenu);
        }
        if (AbstractCyAction.isTrue(props.get("inNodeTableToolBar"))) {
            this.inNodeTableToolBar = true;
        }
        if (AbstractCyAction.isTrue(props.get("inEdgeTableToolBar"))) {
            this.inEdgeTableToolBar = true;
        }
        if (AbstractCyAction.isTrue(props.get("inNetworkTableToolBar"))) {
            this.inNetworkTableToolBar = true;
        }
        if (AbstractCyAction.isTrue(props.get("inUnassignedTableToolBar"))) {
            this.inUnassignedTableToolBar = true;
        }
        if (AbstractCyAction.isTrue(props.get("inMenuBar"))) {
            this.inMenuBar = true;
        }
        if (AbstractCyAction.isTrue(props.get("insertSeparatorBefore"))) {
            this.insertSeparatorBefore = true;
        }
        if (AbstractCyAction.isTrue(props.get("insertSeparatorAfter"))) {
            this.insertSeparatorAfter = true;
        }
        if (AbstractCyAction.isTrue(props.get("insertToolbarSeparatorBefore"))) {
            this.insertToolbarSeparatorBefore = true;
        }
        if (AbstractCyAction.isTrue(props.get("insertToolbarSeparatorAfter"))) {
            this.insertToolbarSeparatorAfter = true;
        }
        if ((keyComboString = props.get("accelerator")) != null && (command = AcceleratorParser.parse(keyComboString)) != null) {
            this.setAcceleratorKeyStroke(command);
        }
        if ((menuGravityString = props.get("menuGravity")) != null) {
            try {
                this.menuGravity = Float.valueOf(menuGravityString).floatValue();
            }
            catch (NumberFormatException nfe) {
                logger.warn("failed to set menuGravity with: " + menuGravityString, (Throwable)nfe);
            }
        }
        if ((toolbarGravityString = props.get("toolBarGravity")) != null) {
            try {
                this.toolbarGravity = Float.valueOf(toolbarGravityString).floatValue();
            }
            catch (NumberFormatException nfe) {
                logger.warn("failed to set toolBarGravity with: " + toolbarGravityString, (Throwable)nfe);
            }
        }
        this.setEnabled(true);
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getToolTipImage() {
        return this.toolTipImage;
    }

    @Override
    public boolean isInMenuBar() {
        return this.inMenuBar;
    }

    @Override
    public void setIsInMenuBar(boolean b) {
        this.inMenuBar = b;
    }

    @Override
    public boolean isInToolBar() {
        return this.inToolBar;
    }

    @Override
    public void setIsInToolBar(boolean b) {
        this.inToolBar = b;
    }

    @Override
    public boolean isInNodeTableToolBar() {
        return this.inNodeTableToolBar;
    }

    @Override
    public void setIsInNodeTableToolBar(boolean b) {
        this.inNodeTableToolBar = b;
    }

    @Override
    public boolean isInEdgeTableToolBar() {
        return this.inEdgeTableToolBar;
    }

    @Override
    public void setIsInEdgeTableToolBar(boolean b) {
        this.inEdgeTableToolBar = b;
    }

    @Override
    public boolean isInNetworkTableToolBar() {
        return this.inNetworkTableToolBar;
    }

    @Override
    public void setIsInNetworkTableToolBar(boolean b) {
        this.inNetworkTableToolBar = b;
    }

    @Override
    public boolean isInUnassignedTableToolBar() {
        return this.inUnassignedTableToolBar;
    }

    @Override
    public void setIsInUnassignedTableToolBar(boolean b) {
        this.inUnassignedTableToolBar = b;
    }

    @Override
    public boolean insertSeparatorBefore() {
        return this.insertSeparatorBefore;
    }

    @Override
    public boolean insertSeparatorAfter() {
        return this.insertSeparatorAfter;
    }

    public boolean insertToolbarSeparatorBefore() {
        return this.insertToolbarSeparatorBefore;
    }

    public boolean insertToolbarSeparatorAfter() {
        return this.insertToolbarSeparatorAfter;
    }

    @Override
    public void setMenuGravity(float gravity) {
        this.menuGravity = gravity;
    }

    @Override
    public float getMenuGravity() {
        return this.menuGravity;
    }

    @Override
    public void setToolbarGravity(float gravity) {
        this.toolbarGravity = gravity;
    }

    @Override
    public float getToolbarGravity() {
        return this.toolbarGravity;
    }

    @Override
    public void setAcceleratorKeyStroke(KeyStroke ks) {
        this.acceleratorKeyStroke = ks;
    }

    @Override
    public KeyStroke getAcceleratorKeyStroke() {
        return this.acceleratorKeyStroke;
    }

    @Override
    public String getPreferredMenu() {
        return this.preferredMenu;
    }

    @Override
    public void setPreferredMenu(String newPreferredMenu) {
        this.preferredMenu = newPreferredMenu;
    }

    @Override
    public boolean useCheckBoxMenuItem() {
        return this.useCheckBoxMenuItem;
    }

    @Override
    public boolean useToggleButton() {
        return this.useToggleButton;
    }

    @Override
    public void menuCanceled(MenuEvent e) {
        this.enabler.updateEnableState();
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        this.enabler.updateEnableState();
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.enabler.updateEnableState();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.enabler.updateEnableState();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void updateEnableState() {
        this.enabler.updateEnableState();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.configurationProperties;
    }

    private URL getURL(String s) {
        if (s == null) {
            return null;
        }
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            logger.warn("Incorrectly formatted URL string: '" + s + "'", (Throwable)e);
            return null;
        }
    }

    private static boolean isTrue(String s) {
        return s != null && Boolean.parseBoolean(s);
    }

    private static class ConjunctionEnableSupport
    extends AbstractEnableSupport {
        private AbstractEnableSupport[] enableSupports;

        public ConjunctionEnableSupport(CyAction action, AbstractEnableSupport ... enableSupports) {
            super(action);
            this.enableSupports = enableSupports;
        }

        @Override
        public void updateEnableState() {
            boolean enabled = true;
            for (AbstractEnableSupport enableSupport : this.enableSupports) {
                enableSupport.updateEnableState();
                if (!(enabled &= enableSupport.isCurrentlyEnabled())) break;
            }
            this.setEnabled(enabled);
        }
    }
}

