/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedListener;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.events.RenderingEngineAboutToBeRemovedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderingEngineManagerImpl
implements RenderingEngineManager,
NetworkViewAboutToBeDestroyedListener,
TableViewAboutToBeDestroyedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<View<?>, Collection<RenderingEngine<?>>> renderingEngineMap;
    private static final String FACTORY_ID_TAG = "id";
    private static final String DEFAULT_FACTORY_ID = "ding";
    private static final String DEFAULT_TABLE_FACTORY_ID = "org.cytoscape.view.table.renderer";
    private VisualLexicon defaultLexicon;
    private VisualLexicon defaultTableLexicon;
    private final Map<String, RenderingEngineFactory<?>> factoryMap;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public RenderingEngineManagerImpl(CyServiceRegistrar serviceRegistrar) {
        if (serviceRegistrar == null) {
            throw new IllegalArgumentException("'serviceRegistrar' must not be null.");
        }
        this.serviceRegistrar = serviceRegistrar;
        this.renderingEngineMap = new WeakHashMap();
        this.factoryMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RenderingEngine<?>> getRenderingEngines(View<?> viewModel) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.renderingEngineMap.containsKey(viewModel)) {
                return Collections.emptySet();
            }
            return this.renderingEngineMap.get(viewModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RenderingEngine<?>> getAllRenderingEngines() {
        HashSet allEngines = new HashSet();
        Object object = this.lock;
        synchronized (object) {
            for (Collection<RenderingEngine<?>> engines : this.renderingEngineMap.values()) {
                allEngines.addAll(engines);
            }
        }
        return allEngines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderingEngine(RenderingEngine<?> renderingEngine) {
        View viewModel = renderingEngine.getViewModel();
        Object object = this.lock;
        synchronized (object) {
            Collection<RenderingEngine<?>> currentVals = this.renderingEngineMap.get(viewModel);
            if (currentVals == null) {
                currentVals = new HashSet();
            }
            currentVals.add(renderingEngine);
            this.renderingEngineMap.put(viewModel, currentVals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderingEngine(RenderingEngine<?> renderingEngine) {
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new RenderingEngineAboutToBeRemovedEvent((RenderingEngineManager)this, renderingEngine));
        Object object = this.lock;
        synchronized (object) {
            View viewModel = renderingEngine.getViewModel();
            Collection<RenderingEngine<?>> currentEngines = this.renderingEngineMap.get(viewModel);
            if (currentEngines != null) {
                currentEngines.remove(renderingEngine);
            }
        }
        renderingEngine.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualLexicon getDefaultVisualLexicon() {
        Object object = this.lock;
        synchronized (object) {
            if (this.defaultLexicon == null) {
                throw new IllegalStateException("Lexicon is not ready yet.");
            }
            return this.defaultLexicon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualLexicon getDefaultTableVisualLexicon() {
        Object object = this.lock;
        synchronized (object) {
            if (this.defaultTableLexicon == null) {
                throw new IllegalStateException("Lexicon is not ready yet.");
            }
            return this.defaultTableLexicon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderingEngineFactory(RenderingEngineFactory<?> factory, Map<?, ?> metadata) {
        Object idObject = metadata.get(FACTORY_ID_TAG);
        if (idObject == null) {
            throw new IllegalArgumentException("Could not add factory: ID metadata is missing for RenderingEngineFactory.");
        }
        String id = idObject.toString();
        Object object = this.lock;
        synchronized (object) {
            this.factoryMap.put(id, factory);
            if (id.equals(DEFAULT_FACTORY_ID)) {
                this.defaultLexicon = factory.getVisualLexicon();
            }
            if (id.equals(DEFAULT_TABLE_FACTORY_ID)) {
                this.defaultTableLexicon = factory.getVisualLexicon();
            }
        }
        logger.debug("New engine registered: " + factory.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderingEngineFactory(RenderingEngineFactory<?> factory, Map<?, ?> metadata) {
        Object idObject = metadata.get(FACTORY_ID_TAG);
        if (idObject == null) {
            throw new IllegalArgumentException("Could not remove factory: ID metadata is missing for RenderingEngineFactory.");
        }
        String id = idObject.toString();
        Object object = this.lock;
        synchronized (object) {
            this.factoryMap.remove(id);
        }
    }

    public void handleEvent(NetworkViewAboutToBeDestroyedEvent e) {
        this.removeRenderingeEngine((View<?>)e.getNetworkView());
    }

    public void handleEvent(TableViewAboutToBeDestroyedEvent e) {
        this.removeRenderingeEngine((View<?>)e.getTableView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRenderingeEngine(View<?> view) {
        Collection<RenderingEngine<?>> engines;
        Iterator<RenderingEngine<?>> iterator = this.lock;
        synchronized (iterator) {
            engines = this.renderingEngineMap.remove(view);
        }
        if (engines != null) {
            for (RenderingEngine<?> engine : engines) {
                engine.dispose();
            }
        }
    }
}

