/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.ui;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.PSIMI25VisualStyleBuilder;
import org.cytoscape.webservice.psicquic.RegistryManager;
import org.cytoscape.webservice.psicquic.task.SearchRecordsTask;
import org.cytoscape.webservice.psicquic.ui.PSIMITagManager;
import org.cytoscape.webservice.psicquic.ui.SelectorBuilder;
import org.cytoscape.webservice.psicquic.ui.SourceStatusPanel;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.swing.DialogTaskManager;

public class PSICQUICSearchUI
extends JPanel {
    private static final long serialVersionUID = 3163269742016489767L;
    private static final Dimension PANEL_SIZE = new Dimension(680, 500);
    static final String PROP_NAME = "psiqcuic.datasource.selection";
    private static final String MIQL_MODE = "Search by Query Language (MIQL)";
    private static final String INTERACTOR_ID_LIST = "Search by ID (gene/protein/compound ID)";
    private static final String BY_SPECIES = "Import Interactome (this may take long time)";
    private final RegistryManager regManager;
    private final PSICQUICRestClient client;
    private JEditorPane queryArea;
    private SourceStatusPanel statusPanel;
    private JScrollPane queryScrollPane;
    private JButton searchButton;
    private JPanel speciesPanel;
    private JComboBox<String> searchModeSelector;
    private JComboBox<SelectorBuilder.Species> speciesSelector;
    private JPanel searchConditionPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton importButton;
    private PSICQUICRestClient.SearchMode mode = PSICQUICRestClient.SearchMode.MIQL;
    private boolean firstClick = true;
    private boolean defKeyStrokesAdded;
    private Set<String> sourceSet = new HashSet<String>();
    private final PSIMI25VisualStyleBuilder vsBuilder;
    private final PSIMITagManager tagManager;
    private final CyServiceRegistrar serviceRegistrar;

    public PSICQUICSearchUI(RegistryManager regManager, PSICQUICRestClient client, PSIMI25VisualStyleBuilder vsBuilder, PSIMITagManager tagManager, CyServiceRegistrar serviceRegistrar) {
        this.regManager = regManager;
        this.client = client;
        this.vsBuilder = vsBuilder;
        this.tagManager = tagManager;
        this.serviceRegistrar = serviceRegistrar;
        CyProperty cyProp = (CyProperty)serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Properties props = (Properties)cyProp.getProperties();
        String selectionListProp = props.getProperty(PROP_NAME);
        if (selectionListProp == null) {
            props.setProperty(PROP_NAME, "");
        } else {
            this.setSelected(selectionListProp);
        }
        this.init();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                PSICQUICSearchUI.this.getQueryArea().requestFocus();
                if (PSICQUICSearchUI.this.getRootPane() != null) {
                    PSICQUICSearchUI.this.getRootPane().setDefaultButton(PSICQUICSearchUI.this.getImportButton());
                    if (!PSICQUICSearchUI.this.defKeyStrokesAdded) {
                        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)PSICQUICSearchUI.this.getRootPane(), (Action)PSICQUICSearchUI.this.getImportButton().getAction(), (Action)PSICQUICSearchUI.this.getCancelButton().getAction());
                    }
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        });
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.createDBlistPanel();
        this.queryModeChanged();
        this.setSize(PANEL_SIZE);
        this.setPreferredSize(PANEL_SIZE);
        this.getQueryArea().addCaretListener(evt -> this.getSearchButton().setEnabled(!this.getQueryArea().getText().isEmpty()));
        this.add(this.getSearchConditionPanel());
        this.add(this.statusPanel);
        this.add(this.getButtonPanel());
    }

    private JPanel getSearchConditionPanel() {
        if (this.searchConditionPanel == null) {
            this.searchConditionPanel = new JPanel();
            this.searchConditionPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"1. Enter Search Conditions"));
            JLabel modeLabel = new JLabel("Search Mode:");
            GroupLayout layout = new GroupLayout(this.searchConditionPanel);
            this.searchConditionPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(modeLabel, -2, -1, -2).addComponent(this.getSearchModeSelector(), -2, -1, -2)).addComponent(this.getQueryScrollPane(), -1, -1, Short.MAX_VALUE).addComponent(this.getSpeciesPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getSearchButton(), -2, -1, -2));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(modeLabel, -2, -1, -2).addComponent(this.getSearchModeSelector(), -2, -1, -2)).addComponent(this.getQueryScrollPane(), -1, -1, Short.MAX_VALUE).addComponent(this.getSpeciesPanel(), -2, -1, -2).addComponent(this.getSearchButton(), -2, -1, -2));
        }
        return this.searchConditionPanel;
    }

    private JScrollPane getQueryScrollPane() {
        if (this.queryScrollPane == null) {
            this.queryScrollPane = new JScrollPane();
            this.queryScrollPane.setHorizontalScrollBarPolicy(31);
            this.queryScrollPane.setPreferredSize(new Dimension(500, 150));
            this.queryScrollPane.setViewportView(this.getQueryArea());
        }
        return this.queryScrollPane;
    }

    private JEditorPane getQueryArea() {
        if (this.queryArea == null) {
            this.queryArea = new JEditorPane();
            this.queryArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    if (PSICQUICSearchUI.this.firstClick) {
                        PSICQUICSearchUI.this.firstClick = false;
                        PSICQUICSearchUI.this.getSearchButton().setEnabled(true);
                    }
                }
            });
        }
        return this.queryArea;
    }

    private JPanel getSpeciesPanel() {
        if (this.speciesPanel == null) {
            this.speciesPanel = new JPanel();
            if (LookAndFeelUtil.isAquaLAF()) {
                this.speciesPanel.setOpaque(false);
            }
            JLabel speciesLabel = new JLabel("Select Species:");
            SelectorBuilder speciesBuilder = new SelectorBuilder();
            this.speciesSelector = speciesBuilder.getComboBox();
            this.getSearchButton().setEnabled(true);
            GroupLayout layout = new GroupLayout(this.speciesPanel);
            this.speciesPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(speciesLabel, -2, -1, -2).addComponent(this.speciesSelector, -2, -1, -2));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(speciesLabel, -2, -1, -2).addComponent(this.speciesSelector, -2, -1, -2));
            this.speciesSelector.addActionListener(evt -> this.getSearchButton().setEnabled(true));
        }
        return this.speciesPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getImportButton(), (JButton)this.getCancelButton());
        }
        return this.buttonPanel;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton(new AbstractAction("Import"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PSICQUICSearchUI.this.statusPanel.doImport();
                }
            });
        }
        return this.importButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Window)PSICQUICSearchUI.this.getRootPane().getParent()).dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private JComboBox<String> getSearchModeSelector() {
        if (this.searchModeSelector == null) {
            this.searchModeSelector = new JComboBox();
            this.searchModeSelector.addItem(BY_SPECIES);
            this.searchModeSelector.addItem(INTERACTOR_ID_LIST);
            this.searchModeSelector.addItem(MIQL_MODE);
            this.searchModeSelector.setSelectedItem(INTERACTOR_ID_LIST);
            this.searchModeSelector.addActionListener(evt -> this.queryModeChanged());
        }
        return this.searchModeSelector;
    }

    private JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton("Search");
            this.searchButton.addActionListener(evt -> {
                this.search();
                this.enableComponents(true);
            });
            this.searchButton.setEnabled(false);
        }
        return this.searchButton;
    }

    private final void setSelected(String selected) {
        String[] sources;
        for (String source : sources = selected.split(",")) {
            this.sourceSet.add(source);
        }
    }

    public final void setSelected() {
        this.sourceSet = this.statusPanel.getSelected();
    }

    private void enableComponents(boolean enable) {
        this.statusPanel.enableComponents(enable);
        this.getImportButton().getAction().setEnabled(enable);
    }

    private final void createDBlistPanel() {
        this.statusPanel = new SourceStatusPanel("", this.client, this.regManager, null, this.mode, this.vsBuilder, this.tagManager, this.serviceRegistrar);
        this.enableComponents(false);
        this.statusPanel.setSelected(this.sourceSet);
    }

    private void search() {
        SearchRecordsTask searchTask = new SearchRecordsTask(this.client, this.mode);
        Map<String, String> activeSource = this.regManager.getActiveServices();
        String query = this.getQueryArea().getText();
        if (this.mode == PSICQUICRestClient.SearchMode.SPECIES) {
            query = this.buildSpeciesQuery();
        }
        this.setSelected();
        this.statusPanel.setQuery(query);
        searchTask.setQuery(query);
        searchTask.setTargets(activeSource.values());
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        taskManager.execute(new TaskIterator(new Task[]{searchTask, new SetTableTask(searchTask)}));
    }

    private final String buildSpeciesQuery() {
        this.mode = PSICQUICRestClient.SearchMode.SPECIES;
        Object selectedItem = this.speciesSelector.getSelectedItem();
        SelectorBuilder.Species species = (SelectorBuilder.Species)((Object)selectedItem);
        return "taxidA:\"" + species.toString() + "\" AND taxidB:\"" + species.toString() + "\"";
    }

    public final void updateGUILayout() {
        this.removeAll();
        if (this.mode == PSICQUICRestClient.SearchMode.SPECIES) {
            this.getQueryScrollPane().setVisible(false);
            this.getSpeciesPanel().setVisible(true);
            this.getSearchButton().setEnabled(true);
        } else {
            this.getQueryScrollPane().setVisible(true);
            this.getSpeciesPanel().setVisible(false);
        }
        this.statusPanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"2. Select Databases"));
        this.add(this.getSearchConditionPanel());
        this.add(this.statusPanel);
        this.add(this.getButtonPanel());
        if (this.getRootPane() != null) {
            Window parentWindow = (Window)this.getRootPane().getParent();
            parentWindow.pack();
            this.repaint();
            parentWindow.toFront();
        }
    }

    private final void queryModeChanged() {
        String query;
        Object selectedObject = this.getSearchModeSelector().getSelectedItem();
        if (selectedObject == null) {
            return;
        }
        String modeString = selectedObject.toString();
        if (modeString.equals(MIQL_MODE)) {
            this.mode = PSICQUICRestClient.SearchMode.MIQL;
            query = this.getQueryArea().getText();
            this.getSearchButton().setEnabled(false);
            this.getQueryArea().requestFocus();
        } else if (modeString.equals(INTERACTOR_ID_LIST)) {
            this.mode = PSICQUICRestClient.SearchMode.INTERACTOR;
            query = this.getQueryArea().getText();
            this.getSearchButton().setEnabled(false);
            this.getQueryArea().requestFocus();
        } else {
            this.mode = PSICQUICRestClient.SearchMode.SPECIES;
            query = this.buildSpeciesQuery();
            this.getSearchButton().setEnabled(true);
        }
        this.firstClick = true;
        this.getQueryArea().setText("");
        this.statusPanel = new SourceStatusPanel(query, this.client, this.regManager, null, this.mode, this.vsBuilder, this.tagManager, this.serviceRegistrar);
        this.statusPanel.sort();
        this.updateGUILayout();
        this.enableComponents(false);
        this.statusPanel.setSelected(this.sourceSet);
    }

    private final class SetTableTask
    extends AbstractTask {
        private final SearchRecordsTask searchTask;

        public SetTableTask(SearchRecordsTask searchTask) {
            this.searchTask = searchTask;
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            Map<String, Long> result = this.searchTask.getResult();
            String query = PSICQUICSearchUI.this.mode == PSICQUICRestClient.SearchMode.SPECIES ? PSICQUICSearchUI.this.buildSpeciesQuery() : PSICQUICSearchUI.this.getQueryArea().getText();
            PSICQUICSearchUI.this.statusPanel = new SourceStatusPanel(query, PSICQUICSearchUI.this.client, PSICQUICSearchUI.this.regManager, result, PSICQUICSearchUI.this.mode, PSICQUICSearchUI.this.vsBuilder, PSICQUICSearchUI.this.tagManager, PSICQUICSearchUI.this.serviceRegistrar);
            PSICQUICSearchUI.this.statusPanel.sort();
            PSICQUICSearchUI.this.updateGUILayout();
            PSICQUICSearchUI.this.enableComponents(true);
            PSICQUICSearchUI.this.statusPanel.setSelected(PSICQUICSearchUI.this.sourceSet);
        }
    }
}

