/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.task;

import java.util.Collection;
import java.util.Map;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRecordsTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger(SearchRecordsTask.class);
    private final PSICQUICRestClient client;
    private final PSICQUICRestClient.SearchMode mode;
    private String query;
    private Collection<String> targetServices;
    private Map<String, Long> result;

    public SearchRecordsTask(PSICQUICRestClient client, PSICQUICRestClient.SearchMode mode) {
        this.client = client;
        this.mode = mode;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Searching PSICQUIC Services");
        taskMonitor.setStatusMessage("Searching databases.  Please wait...");
        taskMonitor.setProgress(0.05);
        if (this.query == null) {
            throw new NullPointerException("Query is null");
        }
        if (this.targetServices == null) {
            throw new NullPointerException("Target service set is null");
        }
        this.result = this.client.search(this.query, this.targetServices, this.mode, taskMonitor);
        taskMonitor.setProgress(1.0);
    }

    public void cancel() {
        this.client.cancel();
    }

    public void setTargets(Collection<String> targetServices) {
        this.targetServices = targetServices;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, Long> getResult() {
        return this.result;
    }
}

