/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.task;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.search.AbstractNetworkSearchTaskFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.PSICQUICWebServiceClient;
import org.cytoscape.webservice.psicquic.PSIMI25VisualStyleBuilder;
import org.cytoscape.webservice.psicquic.task.SearchRecordsTask;
import org.cytoscape.webservice.psicquic.ui.PSIMITagManager;
import org.cytoscape.webservice.psicquic.ui.SourceStatusPanel;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;

public class PSICQUICSearchFactory
extends AbstractNetworkSearchTaskFactory {
    public static String ID = "org.cytoscape.PSICQUIC";
    public static String NAME = "PSICQUIC";
    public static String DESCRIPTION = "Search PSICQUIC-compliant databases.";
    public static String WEBSITE_URL = "http://psicquic.github.io/";
    private static final Icon icon = new ImageIcon(PSICQUICSearchFactory.class.getResource("/images/psicquic-logo-32.png"));
    private URL url;
    private final SearchTaskObserver taskObserver;
    private final PSICQUICWebServiceClient client;
    private final PSIMI25VisualStyleBuilder vsBuilder;
    private final PSIMITagManager tagManager;
    private final CyServiceRegistrar serviceRegistrar;

    public PSICQUICSearchFactory(PSICQUICWebServiceClient client, PSIMI25VisualStyleBuilder vsBuilder, PSIMITagManager tagManager, CyServiceRegistrar serviceRegistrar) {
        super(ID, NAME, DESCRIPTION, icon);
        try {
            this.url = new URL(WEBSITE_URL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.client = client;
        this.vsBuilder = vsBuilder;
        this.tagManager = tagManager;
        this.serviceRegistrar = serviceRegistrar;
        this.taskObserver = new SearchTaskObserver();
    }

    public URL getWebsite() {
        return this.url;
    }

    public TaskObserver getTaskObserver() {
        return this.taskObserver;
    }

    public TaskIterator createTaskIterator() {
        String query = this.getQuery();
        if (query == null) {
            throw new NullPointerException("Query string is null.");
        }
        SearchRecordsTask searchTask = new SearchRecordsTask(this.client.getRestClient(), PSICQUICRestClient.SearchMode.INTERACTOR);
        searchTask.setQuery(query);
        Map<String, String> activeSource = this.client.getRegistryManager().getActiveServices();
        searchTask.setTargets(activeSource.values());
        this.taskObserver.setTask(searchTask);
        return new TaskIterator(new Task[]{searchTask});
    }

    private class SearchTaskObserver
    implements TaskObserver {
        private SearchRecordsTask task;

        private SearchTaskObserver() {
        }

        public void setTask(SearchRecordsTask task) {
            this.task = task;
        }

        public void taskFinished(ObservableTask task) {
        }

        public void allFinished(FinishStatus finishStatus) {
            Map<String, Long> result = this.task.getResult();
            SwingUtilities.invokeLater(() -> {
                final SourceStatusPanel statusPanel = new SourceStatusPanel(this.task.getQuery(), PSICQUICSearchFactory.this.client.getRestClient(), PSICQUICSearchFactory.this.client.getRegistryManager(), result, PSICQUICRestClient.SearchMode.INTERACTOR, PSICQUICSearchFactory.this.vsBuilder, PSICQUICSearchFactory.this.tagManager, PSICQUICSearchFactory.this.serviceRegistrar);
                statusPanel.setBorder(LookAndFeelUtil.createPanelBorder());
                statusPanel.sort();
                statusPanel.enableComponents(true);
                statusPanel.setSelected(result.keySet());
                statusPanel.setPreferredSize(new Dimension(680, 360));
                JFrame parent = ((CySwingApplication)PSICQUICSearchFactory.this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame();
                final JDialog dialog = new JDialog((Window)parent, "Select Databases", Dialog.ModalityType.APPLICATION_MODAL);
                JButton cancelButton = new JButton(new AbstractAction("Cancel"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                JButton importButton = new JButton(new AbstractAction("Import"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        statusPanel.doImport();
                        dialog.dispose();
                    }
                });
                JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)importButton, (JButton)cancelButton);
                GroupLayout layout = new GroupLayout(dialog.getContentPane());
                dialog.getContentPane().setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setAutoCreateGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(statusPanel, -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
                layout.setVerticalGroup(layout.createSequentialGroup().addComponent(statusPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(buttonPanel, -2, -1, -2));
                dialog.getRootPane().setDefaultButton(importButton);
                LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)dialog.getRootPane(), (Action)importButton.getAction(), (Action)cancelButton.getAction());
                dialog.pack();
                dialog.setLocationRelativeTo(parent);
                dialog.setVisible(true);
            });
        }
    }
}

