/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.PSIMI25VisualStyleBuilder;
import org.cytoscape.webservice.psicquic.task.SearchRecordsTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;

public class ImportNetworkFromPSICQUICTask
extends AbstractTask
implements ObservableTask {
    private static final String VIEW_THRESHOLD = "viewThreshold";
    private static final int DEF_VIEW_THRESHOLD = 3000;
    private final PSICQUICRestClient client;
    private String query;
    private Collection<String> targetServices;
    private final String defaultSearchResultURL = "http://www.ebi.ac.uk/Tools/webservices/psicquic/intact/webservices/current/search/";
    private Set<String> searchResult;
    private Map<String, CyNetwork> result;
    private SearchRecordsTask searchTask;
    private final PSICQUICRestClient.SearchMode mode;
    private final boolean mergeNetworks;
    private final PSIMI25VisualStyleBuilder vsBuilder;
    private CyServiceRegistrar serviceRegistrar;
    private volatile boolean canceled;

    public ImportNetworkFromPSICQUICTask(String query, PSICQUICRestClient client, Set<String> searchResult, PSICQUICRestClient.SearchMode mode, PSIMI25VisualStyleBuilder vsBuilder, boolean toCluster, CyServiceRegistrar serviceRegistrar) {
        this.client = client;
        this.query = query;
        this.mergeNetworks = toCluster;
        this.searchResult = searchResult;
        this.mode = mode;
        this.vsBuilder = vsBuilder;
        this.serviceRegistrar = serviceRegistrar;
    }

    public ImportNetworkFromPSICQUICTask(String query, PSICQUICRestClient client, SearchRecordsTask searchTask, PSICQUICRestClient.SearchMode mode, PSIMI25VisualStyleBuilder vsBuilder, CyServiceRegistrar serviceRegistrar) {
        this.client = client;
        this.query = query;
        this.mergeNetworks = false;
        this.searchTask = searchTask;
        this.mode = mode;
        this.vsBuilder = vsBuilder;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Importing Interactions from PSICQUIC Services");
        taskMonitor.setStatusMessage("Loading interactions from remote service...");
        taskMonitor.setProgress(0.01);
        if (this.searchResult == null) {
            this.processSearchResult();
        } else {
            this.targetServices = this.searchResult;
        }
        if (this.searchResult == null) {
            this.searchResult = new HashSet<String>();
            this.searchResult.add("http://www.ebi.ac.uk/Tools/webservices/psicquic/intact/webservices/current/search/");
            this.targetServices = this.searchResult;
        }
        if (this.query == null) {
            throw new NullPointerException("Query is null");
        }
        if (this.targetServices == null) {
            throw new NullPointerException("Target service set is null");
        }
        Date date = new Date();
        SimpleDateFormat timestamp = new SimpleDateFormat("yyyy/MM/dd K:mm:ss a, z");
        String suffix = "(" + timestamp.format(date) + ")";
        this.result = new HashMap<String, CyNetwork>();
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        if (this.mergeNetworks) {
            CyNetwork network = this.client.importMergedNetwork(this.query, this.targetServices, this.mode, taskMonitor);
            network.getRow((CyIdentifiable)network).set("name", (Object)("Merged Network " + suffix));
            this.addNetworkData(network);
            netManager.addNetwork(network);
            this.result.put("clustered", network);
        } else {
            Collection<CyNetwork> networks = this.client.importNetworks(this.query, this.targetServices, this.mode, taskMonitor);
            for (CyNetwork cyNetwork : networks) {
                String networkName = (String)cyNetwork.getRow((CyIdentifiable)cyNetwork).get("name", String.class) + " " + suffix;
                cyNetwork.getRow((CyIdentifiable)cyNetwork).set("name", (Object)networkName);
                this.addNetworkData(cyNetwork);
                netManager.addNetwork(cyNetwork);
                this.result.put(networkName, cyNetwork);
            }
        }
        if (this.canceled) {
            return;
        }
        VisualStyle psiStyle = null;
        VisualMappingManager vmManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        for (VisualStyle style : vmManager.getAllVisualStyles()) {
            if (!style.getTitle().equals("PSIMI 25 Style")) continue;
            psiStyle = style;
            break;
        }
        if (psiStyle == null) {
            psiStyle = this.vsBuilder.getVisualStyle();
            vmManager.addVisualStyle(psiStyle);
        }
        vmManager.setCurrentVisualStyle(psiStyle);
        if (this.canceled) {
            return;
        }
        ArrayList<CyNetwork> arrayList = new ArrayList<CyNetwork>();
        int viewThreshold = this.getViewThreshold();
        for (CyNetwork net : this.result.values()) {
            int numGraphObjects = net.getNodeCount() + net.getEdgeCount();
            if (numGraphObjects >= viewThreshold) continue;
            arrayList.add(net);
        }
        if (this.canceled) {
            return;
        }
        if (!arrayList.isEmpty()) {
            CreateNetworkViewTaskFactory createViewTaskFactory = (CreateNetworkViewTaskFactory)this.serviceRegistrar.getService(CreateNetworkViewTaskFactory.class);
            this.insertTasksAfterCurrentTask(createViewTaskFactory.createTaskIterator(arrayList));
        }
    }

    public void cancel() {
        this.canceled = true;
        this.client.cancel();
    }

    private void addNetworkData(CyNetwork network) {
        network.getRow((CyIdentifiable)network).getTable().createColumn("created by", String.class, true);
        network.getRow((CyIdentifiable)network).set("created by", (Object)"PSICQUIC Web Service");
    }

    private void processSearchResult() {
        Map<String, Long> rs = this.searchTask.getResult();
        this.targetServices = new HashSet<String>();
        for (String sourceURL : rs.keySet()) {
            Long interactionCount = rs.get(sourceURL);
            if (interactionCount == 0L) continue;
            this.targetServices.add(sourceURL);
        }
    }

    public Set<CyNetwork> getNetworks() {
        return new HashSet<CyNetwork>(this.result.values());
    }

    public <T> T getResults(Class<? extends T> type) {
        return (T)this.getNetworks();
    }

    private int getViewThreshold() {
        int threshold;
        Properties props = (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
        String vts = props.getProperty(VIEW_THRESHOLD);
        try {
            threshold = Integer.parseInt(vts);
        }
        catch (Exception e) {
            threshold = 3000;
        }
        return threshold;
    }
}

