/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.webservice.psicquic.PSICQUICRestClient;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import uk.ac.ebi.enfin.mi.cluster.InteractionCluster;

public class ExpandFromSelectedSourcesTask
extends AbstractTask {
    @Tunable(description="Select Data Source:")
    public ListMultipleSelection<String> services;
    private static final String DEFAULT_LAYOUT = "force-directed";
    private final PSICQUICRestClient client;
    private final CyNetworkBuilder builder;
    private final String query;
    private final CyNetworkView netView;
    private final View<CyNode> nodeView;
    private volatile boolean canceled = false;
    private final Map<String, String> sourceMap;
    private final CyServiceRegistrar serviceRegistrar;

    public ExpandFromSelectedSourcesTask(String query, PSICQUICRestClient client, Map<String, String> sourceMap, CyNetworkView parentNetworkView, View<CyNode> nodeView, CyNetworkBuilder builder, CyServiceRegistrar serviceRegistrar) {
        this.client = client;
        this.query = query;
        this.netView = parentNetworkView;
        this.nodeView = nodeView;
        this.sourceMap = sourceMap;
        this.builder = builder;
        this.serviceRegistrar = serviceRegistrar;
        ArrayList<String> sourceNames = new ArrayList<String>(sourceMap.keySet());
        this.services = new ListMultipleSelection(sourceNames);
        this.services.setSelectedValues(sourceNames);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.query == null) {
            throw new NullPointerException("Query is null");
        }
        taskMonitor.setProgress(0.01);
        List selected = this.services.getSelectedValues();
        HashSet<String> targetServices = new HashSet<String>();
        for (String targetURL : selected) {
            targetServices.add(this.sourceMap.get(targetURL));
        }
        InteractionCluster ic = this.client.importNeighbours(this.query, targetServices, PSICQUICRestClient.SearchMode.INTERACTOR, taskMonitor);
        if (this.canceled) {
            ic = null;
            return;
        }
        taskMonitor.setProgress(0.8);
        this.expand(ic);
        CyLayoutAlgorithmManager layoutManager = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutManager.getLayout(DEFAULT_LAYOUT);
        HashSet<View> entries = new HashSet<View>();
        CyNetwork network = (CyNetwork)this.netView.getModel();
        for (CyNode node : network.getNodeList()) {
            CyRow row = network.getRow((CyIdentifiable)node);
            if (!((Boolean)row.get("selected", Boolean.class)).booleanValue()) continue;
            View nv = this.netView.getNodeView(node);
            entries.add(nv);
        }
        TaskIterator itr = layout.createTaskIterator(this.netView, layout.getDefaultLayoutContext(), entries, null);
        this.insertTasksAfterCurrentTask(itr);
        taskMonitor.setProgress(1.0);
    }

    private void expand(InteractionCluster iC) {
        this.builder.addToNetwork(iC, this.netView, this.nodeView);
        VisualStyle vs = ((VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class)).getVisualStyle(this.netView);
        vs.apply(this.netView);
        this.netView.updateView();
    }

    public void cancel() {
        this.canceled = true;
        this.client.cancel();
    }
}

