/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.webservice.psicquic.RegistryManager;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.cytoscape.webservice.psicquic.simpleclient.PSICQUICSimpleClient;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.model.BinaryInteraction;
import uk.ac.ebi.enfin.mi.cluster.InteractionCluster;

public final class PSICQUICRestClient {
    private static final Logger logger = LoggerFactory.getLogger(PSICQUICRestClient.class);
    private static final String MAPPING_NAMES = "uniprotkb,chebi,ddbj/embl/genbank,ensembl,irefindex";
    public static final Long ERROR_SEARCH_FAILED = -1L;
    public static final Long ERROR_TIMEOUT = -2L;
    public static final Long ERROR_CANCEL = -3L;
    private static final long SEARCH_TIMEOUT_MSEC = 1200L;
    private static final long IMPORT_TIMEOUT = 1000L;
    private final RegistryManager regManager;
    private final CyNetworkBuilder builder;
    private final CyServiceRegistrar serviceRegistrar;
    private static volatile boolean canceled = false;

    public PSICQUICRestClient(RegistryManager regManager, CyNetworkBuilder builder, CyServiceRegistrar serviceRegistrar) {
        this.regManager = regManager;
        this.builder = builder;
        this.serviceRegistrar = serviceRegistrar;
    }

    public CyNetwork importMergedNetwork(String query, Collection<String> targetServices, SearchMode mode, TaskMonitor tm) throws IOException {
        InteractionCluster importedCluster = this.importMerged(query, targetServices, mode, tm);
        CyNetwork network = this.builder.buildNetwork(importedCluster);
        tm.setProgress(1.0);
        return network;
    }

    public Collection<CyNetwork> importNetworks(String query, Collection<String> targetServices, SearchMode mode, TaskMonitor tm) throws IOException {
        Map<String, CyNetwork> result = this.importNetworksParallel(query, targetServices, mode, tm);
        HashSet<CyNetwork> networks = new HashSet<CyNetwork>(result.values());
        tm.setProgress(1.0);
        return networks;
    }

    public InteractionCluster importNeighbours(String query, Collection<String> targetServices, SearchMode mode, TaskMonitor tm) throws IOException {
        return this.importMerged(query, targetServices, mode, tm);
    }

    private final InteractionCluster importMerged(String query, Collection<String> targetServices, SearchMode mode, TaskMonitor tm) {
        Map<String, Collection<BinaryInteraction>> result = this.importNetwork(query, targetServices, mode, tm);
        Collection<Collection<BinaryInteraction>> binaryInteractions = result.values();
        ArrayList<BinaryInteraction> allInteractions = new ArrayList<BinaryInteraction>();
        for (Collection<BinaryInteraction> interactions : binaryInteractions) {
            allInteractions.addAll(interactions);
        }
        tm.setStatusMessage("Merging results...");
        InteractionCluster iC = new InteractionCluster();
        iC.setBinaryInteractionIterator(allInteractions.iterator());
        iC.setMappingIdDbNames(MAPPING_NAMES);
        iC.runService();
        return iC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, CyNetwork> importNetworksParallel(String query, Collection<String> targetServices, SearchMode mode, TaskMonitor tm) {
        ConcurrentHashMap<String, CyNetwork> result = new ConcurrentHashMap<String, CyNetwork>();
        canceled = false;
        tm.setTitle("Loading network data from Remote PSICQUIC Services");
        ConcurrentHashMap resultMap = new ConcurrentHashMap();
        ExecutorService exe = Executors.newCachedThreadPool();
        ExecutorCompletionService<CyNetwork> completionService = new ExecutorCompletionService<CyNetwork>(exe);
        long startTime = System.currentTimeMillis();
        double completed = 0.0;
        double increment = 1.0 / (double)targetServices.size();
        TreeSet<String> sourceSet = new TreeSet<String>();
        TreeSet<String> nameSet = new TreeSet<String>();
        HashSet<ImportNetworkTask> taskSet = new HashSet<ImportNetworkTask>();
        for (String string : targetServices) {
            String networkTitle = this.regManager.getSource2NameMap().get(string);
            nameSet.add(networkTitle);
            ImportNetworkTask task = new ImportNetworkTask(networkTitle, string, query, mode, this.serviceRegistrar);
            completionService.submit(task);
            taskSet.add(task);
            sourceSet.add(string);
        }
        int i = 0;
        for (String service : targetServices) {
            if (canceled) {
                logger.warn("Interrupted by user: network import task");
                tm.setTitle("Import Canceled");
                tm.setStatusMessage("Import Canceled: Partial result will be returned.");
                try {
                    exe.shutdownNow();
                    long endTime = System.currentTimeMillis();
                    double sec = (double)(endTime - startTime) / 1000.0;
                    logger.info("PSICUQIC Import terminated by user in " + sec + " sec.");
                }
                catch (Exception ex) {
                    logger.warn("Operation timeout", (Throwable)ex);
                    ImportNetworkTask task = null;
                    return task;
                }
                finally {
                    for (ImportNetworkTask task : taskSet) {
                        task.cancel();
                    }
                    resultMap.clear();
                    taskSet.clear();
                    sourceSet.clear();
                }
                tm.setProgress(1.0);
                return result;
            }
            Future future = null;
            try {
                future = completionService.take();
                CyNetwork ret = (CyNetwork)future.get();
                Object sourceName = null;
                if (ret != null) {
                    sourceName = (String)ret.getRow((CyIdentifiable)ret).get("source", String.class);
                    result.put((String)sourceName, ret);
                }
                tm.setProgress(completed += increment);
                nameSet.remove(sourceName);
                StringBuilder builder = new StringBuilder();
                for (String name : nameSet) {
                    builder.append(name + " ");
                }
                tm.setStatusMessage(" - " + (i + 1) + " / " + targetServices.size() + " tasks finished.  Waiting results from the following databases: " + builder.toString());
            }
            catch (InterruptedException ie) {
                for (ImportNetworkTask t : taskSet) {
                    t.cancel();
                }
                taskSet.clear();
                List<Runnable> tasks = exe.shutdownNow();
                logger.warn("Interrupted: network import.  Remaining = " + tasks.size(), (Throwable)ie);
                resultMap.clear();
                resultMap = null;
                return null;
            }
            catch (ExecutionException e) {
                logger.warn("Error occured in network import", (Throwable)e);
                continue;
            }
            ++i;
        }
        try {
            exe.shutdown();
            exe.awaitTermination(1000L, TimeUnit.SECONDS);
            long l = System.currentTimeMillis();
            double sec = (double)(l - startTime) / 1000.0;
            logger.info("PSICUQIC Import Finished in " + sec + " sec.");
        }
        catch (Exception exception) {
            logger.warn("Import operation timeout", (Throwable)exception);
            Map<String, CyNetwork> map = null;
            return map;
        }
        finally {
            taskSet.clear();
            sourceSet.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Collection<BinaryInteraction>> importNetwork(String query, Collection<String> targetServices, SearchMode mode, TaskMonitor tm) {
        HashMap<String, Collection<BinaryInteraction>> result = new HashMap<String, Collection<BinaryInteraction>>();
        canceled = false;
        tm.setTitle("Loading network data from Remote PSICQUIC Services");
        ConcurrentHashMap resultMap = new ConcurrentHashMap();
        ExecutorService exe = Executors.newCachedThreadPool();
        ExecutorCompletionService<Collection<BinaryInteraction>> completionService = new ExecutorCompletionService<Collection<BinaryInteraction>>(exe);
        long startTime = System.currentTimeMillis();
        double completed = 0.0;
        double increment = 1.0 / (double)targetServices.size();
        TreeSet<String> sourceSet = new TreeSet<String>();
        TreeSet<String> nameSet = new TreeSet<String>();
        HashSet<ImportNetworkAsMitabTask> taskSet = new HashSet<ImportNetworkAsMitabTask>();
        for (String string : targetServices) {
            nameSet.add(this.regManager.getSource2NameMap().get(string));
            ImportNetworkAsMitabTask task = new ImportNetworkAsMitabTask(string, query, mode);
            completionService.submit(task);
            taskSet.add(task);
            sourceSet.add(string);
        }
        int i = 0;
        for (String service : targetServices) {
            if (canceled) {
                logger.warn("Interrupted by user: network import task");
                exe.shutdownNow();
                resultMap.clear();
                resultMap = null;
                return null;
            }
            Future future = null;
            try {
                future = completionService.take();
                Collection ret = (Collection)future.get();
                if (ret != null) {
                    result.put(service, ret);
                }
                tm.setProgress(completed += increment);
                nameSet.remove(this.regManager.getSource2NameMap().get(service));
                tm.setStatusMessage(i + 1 + " / " + targetServices.size() + " tasks finished.\nStill waiting responses from the following databases:\n\n" + ((Object)nameSet).toString());
            }
            catch (InterruptedException ie) {
                for (ImportNetworkAsMitabTask t : taskSet) {
                    t.cancel();
                }
                taskSet.clear();
                List<Runnable> tasks = exe.shutdownNow();
                logger.warn("Interrupted: network import.  Remaining = " + tasks.size(), (Throwable)ie);
                resultMap.clear();
                resultMap = null;
                return null;
            }
            catch (ExecutionException e) {
                logger.warn("Error occured in network import", (Throwable)e);
                continue;
            }
            ++i;
        }
        try {
            exe.shutdown();
            exe.awaitTermination(1000L, TimeUnit.SECONDS);
            long l = System.currentTimeMillis();
            double sec = (double)(l - startTime) / 1000.0;
            logger.info("PSICUQIC Import Finished in " + sec + " sec.");
        }
        catch (Exception exception) {
            logger.warn("Import operation timeout", (Throwable)exception);
            Map<String, Collection<BinaryInteraction>> map = null;
            return map;
        }
        finally {
            taskSet.clear();
            sourceSet.clear();
        }
        return result;
    }

    public Map<String, Long> search(String query, Collection<String> targetServices, SearchMode mode, TaskMonitor tm) {
        canceled = false;
        ConcurrentHashMap<String, Long> resultMap = new ConcurrentHashMap<String, Long>();
        ExecutorService exe = Executors.newCachedThreadPool();
        ExecutorCompletionService<SearchResult> completionService = new ExecutorCompletionService<SearchResult>(exe);
        long startTime = System.currentTimeMillis();
        for (String serviceURL : targetServices) {
            completionService.submit(new SearchTask(serviceURL, query, mode));
        }
        double completed = 0.0;
        double increment = 1.0 / (double)targetServices.size();
        Future future = null;
        int compCount = 0;
        int total = targetServices.size();
        HashSet<String> remaining = new HashSet<String>(targetServices);
        try {
            while ((future = completionService.poll(1200L, TimeUnit.MILLISECONDS)) != null) {
                if (canceled) {
                    logger.warn("Search canceled by user.");
                    tm.setTitle("Search Canceled");
                    for (String timeout : remaining) {
                        resultMap.put(timeout, ERROR_SEARCH_FAILED);
                    }
                    return resultMap;
                }
                try {
                    SearchResult result = (SearchResult)future.get();
                    resultMap.put(result.getUrl(), result.getRecordCount());
                    tm.setProgress(completed += increment);
                    tm.setStatusMessage("Completed: " + ++compCount + "/" + total);
                    remaining.remove(result.getUrl());
                }
                catch (ExecutionException e) {
                    logger.warn("Error occured in search: ", (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.warn("Search canceled: ", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            exe.shutdownNow();
            logger.warn("Interrupted", (Throwable)e);
            for (String timeout : remaining) {
                resultMap.put(timeout, ERROR_SEARCH_FAILED);
            }
            return resultMap;
        }
        tm.setProgress(1.0);
        long endTime = System.currentTimeMillis();
        double sec = (double)(endTime - startTime) / 1000.0;
        logger.info("PSICQUIC DB search finished in " + sec + " sec.");
        for (String timeout : remaining) {
            resultMap.put(timeout, ERROR_TIMEOUT);
        }
        exe.shutdown();
        return resultMap;
    }

    public void cancel() {
        canceled = true;
    }

    private static final class ImportNetworkTask
    implements Callable<CyNetwork> {
        private final String serviceURL;
        private final String query;
        private final SearchMode mode;
        private final CyNetworkBuilder builder;
        private final String networkTitle;
        private CyNetwork network;

        private ImportNetworkTask(String networkTitle, String serviceURL, String query, SearchMode mode, CyServiceRegistrar serviceRegistrar) {
            this.serviceURL = serviceURL;
            this.query = query;
            this.mode = mode;
            this.networkTitle = networkTitle;
            this.builder = new CyNetworkBuilder(serviceRegistrar);
        }

        @Override
        public CyNetwork call() throws Exception {
            String encodedStr = URLEncoder.encode(this.query, "UTF-8");
            encodedStr = encodedStr.replaceAll("\\+", "%20");
            URL queryURL = null;
            Object queryString = "";
            if (this.mode == SearchMode.INTERACTOR) {
                queryString = this.serviceURL + "interactor/" + encodedStr + "?format=tab27";
            } else if (this.mode == SearchMode.MIQL) {
                queryString = this.serviceURL + "query/" + encodedStr + "?format=tab27";
            }
            queryURL = new URL((String)queryString);
            InputStream strm = null;
            try {
                strm = queryURL.openStream();
            }
            catch (Exception ex) {
                logger.warn("MITAB 2.7 is not supported by: " + this.networkTitle);
                queryString = ((String)queryString).split("\\?")[0];
                queryURL = new URL((String)queryString);
                strm = queryURL.openStream();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(strm, Charset.forName("UTF-8").newDecoder()));
            CyNetwork network = this.builder.buildNetwork(reader, this.networkTitle);
            return network;
        }

        public void cancel() {
            canceled = true;
            if (this.network != null) {
                this.network.getRow((CyIdentifiable)this.network).set("name", (Object)this.networkTitle);
            }
        }
    }

    private static final class ImportNetworkAsMitabTask
    implements Callable<Collection<BinaryInteraction>> {
        private final String serviceURL;
        private final String query;
        private final SearchMode mode;

        private ImportNetworkAsMitabTask(String serviceURL, String query, SearchMode mode) {
            this.serviceURL = serviceURL;
            this.query = query;
            this.mode = mode;
        }

        @Override
        public Collection<BinaryInteraction> call() throws Exception {
            String encodedStr = URLEncoder.encode(this.query, "UTF-8");
            encodedStr = encodedStr.replaceAll("\\+", "%20");
            URL queryURL = null;
            if (this.mode == SearchMode.INTERACTOR) {
                queryURL = new URL(this.serviceURL + "interactor/" + encodedStr);
            } else if (this.mode == SearchMode.MIQL) {
                queryURL = new URL(this.serviceURL + "query/" + encodedStr);
            }
            if (queryURL == null) {
                throw new IllegalArgumentException("Could not create query URL.");
            }
            logger.info("Query URL: " + queryURL);
            PsimiTabReader mitabReader = new PsimiTabReader(false);
            return mitabReader.read(queryURL);
        }

        public void cancel() {
            canceled = true;
        }
    }

    private static final class SearchTask
    implements Callable<SearchResult> {
        private final String serviceURL;
        private final String query;
        private final SearchMode mode;

        private SearchTask(String serviceURL, String query, SearchMode mode) {
            this.serviceURL = serviceURL;
            this.query = query;
            this.mode = mode;
        }

        @Override
        public SearchResult call() throws Exception {
            PSICQUICSimpleClient simpleClient = new PSICQUICSimpleClient(this.serviceURL);
            SearchResult result = this.mode == SearchMode.INTERACTOR ? new SearchResult(this.serviceURL, simpleClient.countByInteractor(this.query)) : new SearchResult(this.serviceURL, simpleClient.countByQuery(this.query));
            return result;
        }
    }

    private static final class SearchResult {
        private final String url;
        private final Long recordCount;

        public SearchResult(String url, Long recordCount) {
            this.recordCount = recordCount;
            this.url = url;
        }

        public final Long getRecordCount() {
            return this.recordCount;
        }

        public final String getUrl() {
            return this.url;
        }
    }

    public static enum SearchMode {
        MIQL("Search by Query (MIQL)"),
        INTERACTOR("Search by gene/protein ID list"),
        SPECIES("Search by species");

        private final String name;

        private SearchMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

