/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.edge.bundler.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.cytoscape.edge.bundler.internal.EdgeBundlerRunner;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.BendFactory;
import org.cytoscape.view.presentation.property.values.Handle;
import org.cytoscape.view.presentation.property.values.HandleFactory;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeBundlerTask
extends AbstractNetworkViewTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String BEND_MAP_COLUMN = "BEND_MAP_ID";
    @Tunable(description="Number of handles:")
    public int numNubs = 3;
    @Tunable(description="Spring constant:")
    public double K = 0.003;
    @Tunable(description="Compatability threshold:")
    public double COMPATABILITY_THRESHOLD = 0.3;
    @Tunable(description="Maximum iterations:")
    public int maxIterations = 500;
    private boolean animate = false;
    private double[][][] edgePos;
    private double[][][] nubs;
    private double[][] edgeCompatability;
    private boolean[][] edgeAlign;
    private double[] edgeLength;
    private int[][] edgeMatcher;
    private int numEdges;
    private int selection;
    private final CyServiceRegistrar serviceRegistrar;

    EdgeBundlerTask(CyNetworkView view, int selection, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.selection = selection;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        Collection edgeView;
        if (this.numNubs < 1) {
            this.numNubs = 1;
        }
        if (this.numNubs > 50) {
            logger.warn("Maximum handles is 50.");
            this.numNubs = 50;
        }
        tm.setTitle("Edge Bundle Layout");
        tm.setStatusMessage("Caching network data...");
        ArrayList<View<CyEdge>> edges = null;
        if (this.selection == 0) {
            edges = this.view.getEdgeViews();
        } else if (this.selection == 1) {
            edgeView = this.view.getEdgeViews();
            edges = new ArrayList<View<CyEdge>>(edgeView.size());
            for (View view : edgeView) {
                boolean n1 = (Boolean)this.view.getNodeView(((CyEdge)view.getModel()).getSource()).getVisualProperty(BasicVisualLexicon.EDGE_SELECTED);
                boolean n2 = (Boolean)this.view.getNodeView(((CyEdge)view.getModel()).getTarget()).getVisualProperty(BasicVisualLexicon.EDGE_SELECTED);
                if (!n1 || !n2) continue;
                edges.add(view);
            }
        } else if (this.selection == 2) {
            edgeView = this.view.getEdgeViews();
            edges = new ArrayList(edgeView.size());
            for (View view : edgeView) {
                if (!((Boolean)view.getVisualProperty(BasicVisualLexicon.EDGE_SELECTED)).booleanValue()) continue;
                edges.add(view);
            }
        }
        int ei = 0;
        for (View view : edges) {
            View eSource = this.view.getNodeView(((CyEdge)view.getModel()).getSource());
            View eTarget = this.view.getNodeView(((CyEdge)view.getModel()).getTarget());
            if (eSource.getSUID().equals(eTarget.getSUID())) continue;
            ++ei;
        }
        this.numEdges = ei;
        if (this.numEdges < 2) {
            logger.warn("Less than two edges found.");
            return;
        }
        this.edgePos = new double[2][2][this.numEdges];
        this.nubs = new double[this.numNubs][2][this.numEdges];
        this.edgeLength = new double[this.numEdges];
        ei = 0;
        for (View view : edges) {
            View eSource = this.view.getNodeView(((CyEdge)view.getModel()).getSource());
            View eTarget = this.view.getNodeView(((CyEdge)view.getModel()).getTarget());
            if (eSource.getSUID().equals(eTarget.getSUID())) continue;
            this.edgePos[0][0][ei] = (Double)eSource.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            this.edgePos[0][1][ei] = (Double)eSource.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            this.edgePos[1][0][ei] = (Double)eTarget.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            this.edgePos[1][1][ei] = (Double)eTarget.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            double diffx = this.edgePos[1][0][ei] - this.edgePos[0][0][ei];
            double diffy = this.edgePos[1][1][ei] - this.edgePos[0][1][ei];
            for (int ni = 0; ni < this.numNubs; ++ni) {
                this.nubs[ni][0][ei] = diffx * (double)(ni + 1) / (double)(this.numNubs + 1) + this.edgePos[0][0][ei];
                this.nubs[ni][1][ei] = diffy * (double)(ni + 1) / (double)(this.numNubs + 1) + this.edgePos[0][1][ei];
            }
            this.edgeLength[ei] = Math.sqrt(diffx * diffx + diffy * diffy);
            ++ei;
        }
        this.computeEdgeCompatability(tm);
        if (this.cancelled) {
            logger.info("Edge bundling cancelled.");
            this.edgeCompatability = null;
            this.edgeAlign = null;
            return;
        }
        tm.setStatusMessage("Simulating physics");
        double time = System.nanoTime();
        double maxItrDouble = this.maxIterations;
        double[][][] forces = new double[this.numNubs][2][this.numEdges];
        HandleFactory handleFactory = (HandleFactory)this.serviceRegistrar.getService(HandleFactory.class);
        BendFactory bendFactory = (BendFactory)this.serviceRegistrar.getService(BendFactory.class);
        VisualMappingManager visualMappingManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualMappingFunctionFactory discreteFactory = (VisualMappingFunctionFactory)this.serviceRegistrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=discrete)");
        for (int iteri = 0; iteri < this.maxIterations; ++iteri) {
            if (this.cancelled) {
                logger.info("Edge bundling cancelled: iter=" + iteri);
                break;
            }
            tm.setProgress((double)iteri / maxItrDouble);
            this.updateForces(forces);
            this.updateNubs(forces);
            if (iteri % 1000 == 0 && this.isConverged(forces, 0.01)) {
                logger.info("Edge bundling converged: iter=" + iteri);
                break;
            }
            if (iteri == this.maxIterations - 1) {
                logger.info("Edge bundling did not converge: iter=" + iteri);
                break;
            }
            if (!this.animate || !((double)System.nanoTime() - time > 3.0)) continue;
            this.render(edges, handleFactory, bendFactory, visualMappingManager, discreteFactory);
            time = System.nanoTime();
        }
        this.render(edges, handleFactory, bendFactory, visualMappingManager, discreteFactory);
    }

    private boolean isConverged(double[][][] forces, double threshold) {
        for (int ei = 0; ei < this.edgeLength.length; ++ei) {
            for (int ni = 0; ni < this.numNubs; ++ni) {
                if (!(Math.abs(forces[ni][0][ei]) > threshold) && !(Math.abs(forces[ni][1][ei]) > threshold)) continue;
                return false;
            }
        }
        return true;
    }

    private final void render(Collection<View<CyEdge>> edges, HandleFactory hf, BendFactory bf, VisualMappingManager vmm, VisualMappingFunctionFactory discreteFactory) {
        VisualStyle style = vmm.getVisualStyle(this.view);
        VisualMappingFunction bendMapping = style.getVisualMappingFunction((VisualProperty)BasicVisualLexicon.EDGE_BEND);
        Map existingMap = null;
        if (bendMapping != null && bendMapping instanceof DiscreteMapping) {
            String columnName = bendMapping.getMappingColumnName();
            if (columnName.equals(BEND_MAP_COLUMN)) {
                existingMap = ((DiscreteMapping)bendMapping).getAll();
            } else {
                bendMapping = (DiscreteMapping)discreteFactory.createVisualMappingFunction(BEND_MAP_COLUMN, Long.class, (VisualProperty)BasicVisualLexicon.EDGE_BEND);
            }
        }
        HashMap<Long, Bend> mappingValues = new HashMap<Long, Bend>();
        CyNetwork network = (CyNetwork)this.view.getModel();
        CyTable edgeTable = network.getTable(CyEdge.class, "LOCAL_ATTRS");
        CyColumn bendMapColumn = edgeTable.getColumn(BEND_MAP_COLUMN);
        if (bendMapColumn == null) {
            edgeTable.createColumn(BEND_MAP_COLUMN, Long.class, false);
        }
        int ei = 0;
        for (View<CyEdge> edge : edges) {
            Long edgeId = ((CyEdge)edge.getModel()).getSUID();
            View eSource = this.view.getNodeView(((CyEdge)edge.getModel()).getSource());
            View eTarget = this.view.getNodeView(((CyEdge)edge.getModel()).getTarget());
            network.getRow((CyIdentifiable)edge.getModel()).set(BEND_MAP_COLUMN, (Object)edgeId);
            if (eSource.getSUID().equals(eTarget.getSUID())) continue;
            Bend bend = bf.createBend();
            List hlist = bend.getAllHandles();
            for (int ni = 0; ni < this.numNubs; ++ni) {
                double x = this.nubs[ni][0][ei];
                double y = this.nubs[ni][1][ei];
                Handle h = hf.createHandle(this.view, edge, x, y);
                hlist.add(h);
            }
            mappingValues.put(edgeId, bend);
            ++ei;
        }
        if (bendMapping == null) {
            DiscreteMapping function = (DiscreteMapping)discreteFactory.createVisualMappingFunction(BEND_MAP_COLUMN, Long.class, (VisualProperty)BasicVisualLexicon.EDGE_BEND);
            style.addVisualMappingFunction((VisualMappingFunction)function);
            function.putAll(mappingValues);
        } else {
            if (existingMap != null) {
                mappingValues.putAll(existingMap);
            }
            ((DiscreteMapping)bendMapping).putAll(mappingValues);
        }
    }

    private void computeEdgeCompatability(TaskMonitor tm) {
        this.edgeCompatability = new double[this.edgeLength.length][];
        this.edgeAlign = new boolean[this.edgeLength.length][];
        this.edgeMatcher = new int[this.edgeLength.length][];
        this.edgeMatcher[0] = new int[0];
        for (int ei = 1; ei < this.edgeLength.length; ++ei) {
            tm.setStatusMessage("Preparing data for edge bundling (" + ei + "/" + this.edgeLength.length + ")");
            if (this.cancelled) break;
            this.edgeCompatability[ei] = new double[ei];
            this.edgeAlign[ei] = new boolean[ei];
            ArrayList<Integer> compatibleEdges = new ArrayList<Integer>(1000);
            for (int ej = 0; ej < ei && !this.cancelled; ++ej) {
                this.edgeCompatability[ei][ej] = this.cangle(ei, ej) * this.cscale(ei, ej) * this.cpos(ei, ej) * this.cvis(ei, ej);
                boolean bl = this.edgeAlign[ei][ej] = this.cangleSign(ei, ej) > 0.0;
                if (!(this.edgeCompatability[ei][ej] > this.COMPATABILITY_THRESHOLD)) continue;
                compatibleEdges.add(ej);
            }
            this.edgeMatcher[ei] = new int[compatibleEdges.size()];
            for (int i = 0; i < compatibleEdges.size() && !this.cancelled; ++i) {
                this.edgeMatcher[ei][i] = (Integer)compatibleEdges.get(i);
            }
        }
    }

    private double cangle(int ei, int ej) {
        double a = this.edgePos[1][0][ei] - this.edgePos[0][0][ei];
        double c = this.edgePos[1][0][ej] - this.edgePos[0][0][ej];
        double b = this.edgePos[1][1][ei] - this.edgePos[0][1][ei];
        double d = this.edgePos[1][1][ej] - this.edgePos[0][1][ej];
        double cosAlpha = (a * c + b * d) / (this.edgeLength[ei] * this.edgeLength[ej]);
        double out = Math.abs(cosAlpha);
        if (Double.isNaN(out) || Double.isInfinite(out)) {
            return 0.0;
        }
        return out;
    }

    private double cangleSign(int ei, int ej) {
        double a = this.edgePos[1][0][ei] - this.edgePos[0][0][ei];
        double c = this.edgePos[1][0][ej] - this.edgePos[0][0][ej];
        double b = this.edgePos[1][1][ei] - this.edgePos[0][1][ei];
        double d = this.edgePos[1][1][ej] - this.edgePos[0][1][ej];
        double cosAlpha = (a * c + b * d) / (this.edgeLength[ei] * this.edgeLength[ej]);
        double out = Math.signum(cosAlpha);
        if (Double.isNaN(out) || Double.isInfinite(out)) {
            return 0.0;
        }
        return out;
    }

    private double cscale(int ei, int ej) {
        double lavg = (this.edgeLength[ei] + this.edgeLength[ej]) / 2.0;
        double out = 2.0 / (lavg / Math.min(this.edgeLength[ei], this.edgeLength[ej]) + Math.max(this.edgeLength[ei], this.edgeLength[ej]) / lavg);
        if (Double.isNaN(out) || Double.isInfinite(out)) {
            return 0.0;
        }
        return out;
    }

    private double cpos(int ei, int ej) {
        double lavg = (this.edgeLength[ei] + this.edgeLength[ej]) / 2.0;
        double out = lavg / (lavg + this.distance(this.mid(ei), this.mid(ej)));
        if (Double.isNaN(out) || Double.isInfinite(out)) {
            return 0.0;
        }
        return out;
    }

    private double[] mid(int ei) {
        return new double[]{(this.edgePos[1][0][ei] + this.edgePos[0][0][ei]) / 2.0, (this.edgePos[1][1][ei] + this.edgePos[0][1][ei]) / 2.0};
    }

    private double distance(double[] p, double[] q) {
        double x = p[0] - q[0];
        double y = p[1] - q[1];
        return Math.sqrt(x * x + y * y);
    }

    private double cvis(int ei, int ej) {
        return Math.min(this.vis(ei, ej), this.vis(ej, ei));
    }

    private double vis(int ei, int ej) {
        double[] I0 = this.getProjection(ei, ej, new double[]{this.edgePos[0][0][ei], this.edgePos[0][1][ei]});
        if (I0 == null) {
            return 0.0;
        }
        double[] I1 = this.getProjection(ei, ej, new double[]{this.edgePos[1][0][ei], this.edgePos[1][1][ei]});
        if (I1 == null) {
            return 0.0;
        }
        double[] Im = new double[]{(I1[0] - I0[0]) / 2.0 + I0[0], (I1[1] - I0[1]) / 2.0 + I0[1]};
        double[] Pm = this.mid(ej);
        double a = this.distance(Pm, Im);
        double b = this.distance(I0, I1);
        return Math.max(1.0 - 2.0 * a / b, 0.0);
    }

    private double[] getProjection(int ei, int ej, double[] m) {
        double dx1 = this.edgePos[1][0][ei] - this.edgePos[0][0][ei];
        double dy1 = this.edgePos[1][1][ei] - this.edgePos[0][1][ei];
        double dx2 = this.edgePos[1][0][ej] - this.edgePos[0][0][ej];
        double dy2 = this.edgePos[1][1][ej] - this.edgePos[0][1][ej];
        double cx = this.edgePos[0][0][ej];
        double cy = this.edgePos[0][1][ej];
        double A1 = dx1;
        double B1 = dy1;
        double A2 = dy2;
        double B2 = -dx2;
        double C1 = A1 * m[0] + B1 * m[1];
        double C2 = A2 * cx + B2 * cy;
        double det = A1 * B2 - A2 * B1;
        if (Math.abs(det) < 1.0E-10) {
            return null;
        }
        double x = (B2 * C1 - B1 * C2) / det;
        double y = (A1 * C2 - A2 * C1) / det;
        return new double[]{x, y};
    }

    private void updateForces(double[][][] forces) {
        int ni;
        for (int ei = 0; ei < this.edgeLength.length; ++ei) {
            for (ni = 0; ni < this.numNubs; ++ni) {
                if (ni == 0) {
                    forces[ni][0][ei] = this.nubs[ni][0][ei] - this.edgePos[0][0][ei];
                    forces[ni][1][ei] = this.nubs[ni][1][ei] - this.edgePos[0][1][ei];
                } else {
                    forces[ni][0][ei] = this.nubs[ni][0][ei] - this.nubs[ni - 1][0][ei];
                    forces[ni][1][ei] = this.nubs[ni][1][ei] - this.nubs[ni - 1][1][ei];
                }
                if (ni == this.numNubs - 1) {
                    double[] dArray = forces[ni][0];
                    int n = ei;
                    dArray[n] = dArray[n] + (this.nubs[ni][0][ei] - this.edgePos[1][0][ei]);
                    double[] dArray2 = forces[ni][1];
                    int n2 = ei;
                    dArray2[n2] = dArray2[n2] + (this.nubs[ni][1][ei] - this.edgePos[1][1][ei]);
                } else {
                    double[] dArray = forces[ni][0];
                    int n = ei;
                    dArray[n] = dArray[n] + (this.nubs[ni][0][ei] - this.nubs[ni + 1][0][ei]);
                    double[] dArray3 = forces[ni][1];
                    int n3 = ei;
                    dArray3[n3] = dArray3[n3] + (this.nubs[ni][1][ei] - this.nubs[ni + 1][1][ei]);
                }
                double[] dArray = forces[ni][0];
                int n = ei;
                dArray[n] = dArray[n] * -this.K;
                double[] dArray4 = forces[ni][1];
                int n4 = ei;
                dArray4[n4] = dArray4[n4] * -this.K;
            }
        }
        ExecutorService exec = Executors.newCachedThreadPool();
        for (ni = 0; ni < this.numNubs; ++ni) {
            exec.execute(new EdgeBundlerRunner(ni, this.numNubs, this.edgeAlign, this.nubs, forces, this.edgeCompatability, this.edgeMatcher));
        }
        exec.shutdown();
        try {
            exec.awaitTermination(30L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            exec.shutdownNow();
        }
    }

    private void updateNubs(double[][][] forces) {
        for (int ei = 0; ei < this.edgeLength.length; ++ei) {
            for (int ni = 0; ni < this.numNubs; ++ni) {
                double[] dArray = this.nubs[ni][0];
                int n = ei;
                dArray[n] = dArray[n] + forces[ni][0][ei];
                double[] dArray2 = this.nubs[ni][1];
                int n2 = ei;
                dArray2[n2] = dArray2[n2] + forces[ni][1][ei];
            }
        }
    }
}

