/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.edge.bundler.internal;

public final class EdgeBundlerRunner
implements Runnable {
    private final int ni;
    private final int numNubs;
    private final boolean[][] edgeAlign;
    private final double[][][] nubs;
    private final double[][][] forces;
    private final double[][] edgeCompatability;
    private final int[][] edgeMatcher;

    public EdgeBundlerRunner(int ni, int numNubs, boolean[][] edgeAlign, double[][][] nubs, double[][][] forces, double[][] edgeCompatability, int[][] edgeMatcher) {
        this.ni = ni;
        this.numNubs = numNubs;
        this.edgeAlign = edgeAlign;
        this.nubs = nubs;
        this.forces = forces;
        this.edgeCompatability = edgeCompatability;
        this.edgeMatcher = edgeMatcher;
    }

    @Override
    public void run() {
        int size = this.edgeAlign.length;
        for (int ei = 0; ei < size; ++ei) {
            for (int em = 0; em < this.edgeMatcher[ei].length; ++em) {
                int ej = this.edgeMatcher[ei][em];
                int nj = this.edgeAlign[ei][ej] ? this.ni : this.numNubs - this.ni - 1;
                double diffx = this.nubs[this.ni][0][ei] - this.nubs[nj][0][ej];
                double diffy = this.nubs[this.ni][1][ei] - this.nubs[nj][1][ej];
                if (Math.abs(diffx) > 1.0) {
                    double fx = this.edgeCompatability[ei][ej] / diffx;
                    double[] dArray = this.forces[this.ni][0];
                    int n = ei;
                    dArray[n] = dArray[n] - fx;
                    double[] dArray2 = this.forces[nj][0];
                    int n2 = ej;
                    dArray2[n2] = dArray2[n2] + fx;
                }
                if (!(Math.abs(diffy) > 1.0)) continue;
                double fy = this.edgeCompatability[ei][ej] / diffy;
                double[] dArray = this.forces[this.ni][1];
                int n = ei;
                dArray[n] = dArray[n] - fy;
                double[] dArray3 = this.forces[nj][1];
                int n3 = ej;
                dArray3[n3] = dArray3[n3] + fy;
            }
        }
    }
}

