/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.tasks;

import org.cytoscape.cyChart.internal.charts.oneD.HistogramFilterDialog;
import org.cytoscape.cyChart.internal.model.CyChartManager;
import org.cytoscape.cyChart.internal.tasks.AbstractEmptyObservableTask;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class HistogramFilterTask
extends AbstractEmptyObservableTask {
    private String title = "Histogram Plot";
    @Tunable(description="X Axis Parameter", context="nogui")
    public String xColumn = "Degree";
    private final CyChartManager manager;
    private CyColumn column;

    @ProvidesTitle
    public String getTitle() {
        return this.title;
    }

    public HistogramFilterTask(CyChartManager mgr) {
        this(mgr, null);
    }

    public HistogramFilterTask(CyChartManager mgr, CyColumn col) {
        this.manager = mgr;
        this.column = col;
        if (this.column == null) {
            CyTable table = this.manager.getCurrentTable();
            this.column = table.getColumn(this.xColumn);
            if (this.column == null) {
                this.column = table.getColumn("EdgeCount");
            }
            if (this.column == null) {
                this.column = table.getColumn("OutDegree");
            }
        }
    }

    @Override
    public void run(TaskMonitor monitor) {
        this.manager.setXColumn(this.column);
        monitor.setStatusMessage("Building histogram");
        CyNetwork net = this.manager.getCurrentNetwork();
        this.title = net.getDefaultNetworkTable().getTitle();
        HistogramFilterDialog dlog = new HistogramFilterDialog(this.manager, this.title);
        dlog.setVisible(true);
    }
}

