/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import org.cytoscape.cyChart.internal.charts.oneD.Histogram1D;

public class Peak
implements Comparable<Peak> {
    private double mean;
    private double stdev;
    private double amplitude;
    private double area;
    private double min;
    private double max;
    private Histogram1D histogram;
    private XYChart<Number, Number> chart;
    NumberAxis xAxis;
    NumberAxis yAxis;
    private Path path;

    public Peak() {
        this(1.0, 1.0, 1.0);
    }

    public Peak(double m, double s, double a) {
        this.mean = m;
        this.stdev = s;
        this.amplitude = a;
        this.area = 0.0;
        this.min = 0.0;
        this.max = 1.0;
        this.path = null;
    }

    public Peak(Histogram1D h, XYChart<Number, Number> c) {
        this();
        this.histogram = h;
        this.setChart(c);
        this.path = new Path();
    }

    public void setChart(XYChart<Number, Number> c) {
        this.chart = c;
        if (c != null) {
            this.xAxis = (NumberAxis)this.chart.getXAxis();
            this.yAxis = (NumberAxis)this.chart.getYAxis();
        }
    }

    public String toString() {
        return String.format("[ %.0f - %.0f ] %.2f @ %.2f, area: %.2f", this.min, this.max, this.amplitude, this.mean, this.area);
    }

    @Override
    public int compareTo(Peak x) {
        return x.mean > this.mean ? -1 : 1;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public double getStdev() {
        return this.stdev;
    }

    public void setStdev(double d) {
        this.stdev = d;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public double getUnitAmplitude() {
        return this.amplitude / (double)this.histogram.getArea();
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public Histogram1D getHistogram() {
        return this.histogram;
    }

    public void setHistogram(Histogram1D h) {
        this.histogram = h;
    }

    public void setBounds(double a, double b) {
        this.min = a;
        this.max = b;
    }

    public double getWidth() {
        return this.max - this.min;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double a) {
        this.area = a;
    }

    public void addArea(double a) {
        this.area += a;
    }

    public double get(double x) {
        return Peak.gauss(x, this.mean, this.stdev, this.getUnitAmplitude());
    }

    public double getCV() {
        return this.stdev / this.mean;
    }

    public void calcStdev() {
        double width = 1.0 + this.max - this.min;
        this.amplitude = this.area / width;
        double var = 0.0;
        int i = (int)this.min;
        while ((double)i < this.max) {
            double d = this.amplitude - (double)this.histogram.get(i);
            var += d * d;
            ++i;
        }
        this.stdev = Math.sqrt(var / width);
    }

    public static double gauss(double x, double mn, double sd, double amp) {
        double exp = -((x - mn) * (x - mn)) / (2.0 * sd * sd);
        double denom = sd * Math.sqrt(Math.PI * 2);
        double val = amp * Math.exp(exp) / denom;
        return val;
    }

    public Path getPath() {
        if (this.chart != null) {
            this.path.getElements().clear();
            double startBin = this.getMin();
            double endBin = this.getMax();
            double lowery = this.yAxis.getLowerBound();
            double uppery = this.yAxis.getUpperBound();
            Histogram1D histo = this.getHistogram();
            double y0 = this.yAxis.getDisplayPosition(this.yAxis.toRealValue(lowery));
            Point2D left = new Point2D(this.xAxis.getDisplayPosition((Number)histo.binToVal((int)startBin)), y0);
            Point2D right = new Point2D(this.xAxis.getDisplayPosition((Number)histo.binToVal((int)endBin)), y0);
            int meanBin = (int)this.getMean();
            double x = histo.binToVal(meanBin);
            double h = this.xAxis.getDisplayPosition((Number)x);
            double y = histo.getValue(meanBin) / (double)histo.getArea();
            double v = this.yAxis.getDisplayPosition((Number)y);
            double altV = this.get(meanBin);
            double altV2 = this.yAxis.getDisplayPosition((Number)altV);
            Point2D center = new Point2D(h, v);
            boolean showRightEdge = true;
            boolean showLefEdge = true;
            Point2D[] dataPoints = new Point2D[]{left, center, right};
            this.path.setStroke((Paint)Color.BLUE);
            if (showLefEdge) {
                this.path.getElements().addAll((Object[])new PathElement[]{new MoveTo(left.getX(), y0), new LineTo(left.getX(), uppery)});
            }
            this.path.getElements().add((Object)new MoveTo(left.getX(), left.getY()));
            for (Point2D point : dataPoints) {
                this.path.getElements().add((Object)new LineTo(point.getX(), point.getY()));
            }
            if (showRightEdge) {
                this.path.getElements().addAll((Object[])new PathElement[]{new MoveTo(right.getX(), y0), new LineTo(right.getX(), uppery)});
            }
        }
        return this.path;
    }

    private Point2D getPoint(int xBin, NumberAxis xAxis, NumberAxis yAxis) {
        double x = this.histogram.binToVal(xBin);
        double xPosition = xAxis.getDisplayPosition((Number)x);
        double yVal = this.get(xBin);
        double yPosition = yAxis.getDisplayPosition((Number)yVal);
        return new Point2D(xPosition, yPosition);
    }

    public void setNode(Node n) {
        if (n instanceof Path) {
            this.path = (Path)n;
        }
    }
}

