/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import com.sun.javafx.charts.ChartLayoutAnimator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Parent;
import javafx.scene.chart.ValueAxis;
import javafx.util.Duration;

public class LogarithmicAxis
extends ValueAxis<Number> {
    private Object currentAnimationID;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator((Parent)this);
    private final DoubleProperty logUpperBound = new SimpleDoubleProperty();
    private final DoubleProperty logLowerBound = new SimpleDoubleProperty();

    public LogarithmicAxis() {
        super(1.0, 1.0E7);
        this.bindLogBoundsToDefaultBounds();
    }

    public LogarithmicAxis(double lowerBound, double upperBound) {
        super(lowerBound, upperBound);
        this.validateBounds(lowerBound, upperBound);
        this.bindLogBoundsToDefaultBounds();
    }

    public void setLogarithmizedUpperBound(double d) {
        double nd = Math.pow(10.0, Math.ceil(Math.log10(d)));
        this.setUpperBound(nd == d ? nd * 10.0 : nd);
    }

    private void bindLogBoundsToDefaultBounds() {
        this.logLowerBound.bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Math.log10(LogarithmicAxis.this.lowerBoundProperty().get());
            }
        });
        this.logUpperBound.bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Math.log10(LogarithmicAxis.this.upperBoundProperty().get());
            }
        });
    }

    private void validateBounds(double lowerBound, double upperBound) throws IllegalLogarithmicRangeException {
        if (lowerBound < 0.0 || upperBound < 0.0 || lowerBound > upperBound) {
            throw new IllegalLogarithmicRangeException("The logarithmic range should be in [0,Double.MAX_VALUE] and the lowerBound should be less than the upperBound");
        }
    }

    protected List<Number> calculateMinorTickMarks() {
        ArrayList<Number> minorTickMarksPositions = new ArrayList<Number>();
        return minorTickMarksPositions;
    }

    protected List<Number> calculateTickValues(double length, Object range) {
        LinkedList<Number> tickPositions = new LinkedList<Number>();
        if (range != null) {
            double lowerBound = ((double[])range)[0];
            double upperBound = ((double[])range)[1];
            for (double i = Math.log10(lowerBound); i <= Math.log10(upperBound); i += 1.0) {
                tickPositions.add(Math.pow(10.0, i));
            }
            if (!tickPositions.isEmpty() && tickPositions.getLast().doubleValue() != upperBound) {
                tickPositions.add(upperBound);
            }
        }
        return tickPositions;
    }

    protected double[] getRange() {
        return new double[]{this.getLowerBound(), this.getUpperBound()};
    }

    protected String getTickMarkLabel(Number value) {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumIntegerDigits(10);
        formatter.setMinimumIntegerDigits(1);
        return formatter.format(value);
    }

    protected void setRange(Object range, boolean animate) {
        if (range != null) {
            double[] rangeProps = (double[])range;
            double lowerBound = rangeProps[0];
            double upperBound = rangeProps[1];
            double oldLowerBound = this.getLowerBound();
            this.setLowerBound(lowerBound);
            this.setUpperBound(upperBound);
            if (animate) {
                this.animator.stop(this.currentAnimationID);
                this.currentAnimationID = this.animator.animate(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)oldLowerBound)}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)lowerBound)})});
            } else {
                this.currentLowerBound.set(lowerBound);
            }
        }
    }

    public Number getValueForDisplay(double displayPosition) {
        double delta = this.logUpperBound.get() - this.logLowerBound.get();
        if (this.getSide().isVertical()) {
            return Math.pow(10.0, (displayPosition - this.getHeight()) / -this.getHeight() * delta + this.logLowerBound.get());
        }
        return Math.pow(10.0, displayPosition / this.getWidth() * delta + this.logLowerBound.get());
    }

    public double getDisplayPosition(Number value) {
        double delta = this.logUpperBound.get() - this.logLowerBound.get();
        double deltaV = Math.log10(value.doubleValue()) - this.logLowerBound.get();
        if (this.getSide().isVertical()) {
            return (1.0 - deltaV / delta) * this.getHeight();
        }
        return deltaV / delta * this.getWidth();
    }

    public class IllegalLogarithmicRangeException
    extends RuntimeException {
        public IllegalLogarithmicRangeException(String message) {
            super(message);
        }
    }
}

