/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.chart.XYChart;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.cytoscape.cyChart.internal.charts.StringUtil;
import org.cytoscape.cyChart.internal.charts.oneD.Histogram1D;
import org.cytoscape.cyChart.internal.charts.oneD.OverlaidLineChart;
import org.cytoscape.cyChart.internal.model.GraphRequest;
import org.cytoscape.cyChart.internal.model.MixedDataRow;
import org.cytoscape.cyChart.internal.model.Range;

public class CSVTableData {
    private String name;
    private List<StringUtil.TYPES> types;
    private List<String> columnNames;
    private List<MixedDataRow> rows;
    private List<Range> ranges;
    private Map<String, Histogram1D> histograms;
    private Map<String, Map<String, Histogram1D>> gatedHistogramMap;
    static final String TAB = "\t";
    static final String COMMA = ",";
    int xIndex = 0;
    int yIndex = 1;
    int nDimensions = 8;

    public CSVTableData(String id) {
        this.name = id;
        this.types = new ArrayList<StringUtil.TYPES>();
        this.columnNames = FXCollections.observableArrayList();
        this.rows = new ArrayList<MixedDataRow>();
        this.ranges = new ArrayList<Range>();
        this.histograms = new HashMap<String, Histogram1D>();
    }

    public static CSVTableData readCSVfile(String path) {
        CSVTableData tableData = new CSVTableData(path);
        int lineCt = 0;
        try {
            FileInputStream fis = new FileInputStream(new File(path));
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            line = br.readLine();
            String[] columns = line.split(COMMA);
            String[] strs = line.split(COMMA);
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = StringUtil.stripQuotes(strs[i]);
            }
            tableData.setColumnNames(Arrays.asList(strs));
            int len = columns.length;
            line = br.readLine();
            while (line != null) {
                String[] row = line.split(COMMA);
                if (row.length != len) {
                    throw new IllegalArgumentException();
                }
                MixedDataRow dataRow = new MixedDataRow(row.length);
                for (int i = 0; i < row.length; ++i) {
                    String txt = StringUtil.stripQuotes(row[i]);
                    dataRow.setString(i, txt);
                    if (!StringUtil.isNumber(txt)) continue;
                    dataRow.set(i, StringUtil.toDouble(txt));
                }
                tableData.getData().add(dataRow);
                line = br.readLine();
                ++lineCt;
            }
            br.close();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        tableData.calculateRanges();
        tableData.generateHistograms();
        return tableData;
    }

    public void clear() {
        this.types.clear();
        this.columnNames.clear();
        this.rows.clear();
        this.ranges.clear();
        this.histograms.clear();
    }

    public int nRows() {
        return this.rows.size();
    }

    public int nColumns() {
        return this.columnNames.size();
    }

    private int getIndexByStart(String name) {
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (!this.columnNames.get(i).startsWith(name)) continue;
            return i;
        }
        return -1;
    }

    private String getIndex(int i) {
        return this.columnNames.get(i);
    }

    public String getName() {
        return this.name;
    }

    public List<StringUtil.TYPES> getTypes() {
        return this.types;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public Range getRange(int i) {
        return this.ranges.get(i);
    }

    public Map<String, Histogram1D> getHistograms() {
        return this.histograms;
    }

    public Histogram1D getHistogram(String name) {
        if (this.histograms.isEmpty()) {
            this.generateHistograms();
        }
        return this.histograms.get(name);
    }

    public Map<String, Histogram1D> getGatedHistograms(String popname) {
        return "All".equals(popname) || "^".equals(popname) ? this.histograms : this.gatedHistogramMap.get(popname);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getNumericColumnNames() {
        ArrayList<String> cols = new ArrayList<String>();
        for (int i = 0; i < this.types.size(); ++i) {
            if (!StringUtil.isNumber(this.types.get(i))) continue;
            cols.add(this.columnNames.get(i));
        }
        return cols;
    }

    public int getCount() {
        return this.rows.size();
    }

    public int getWidth() {
        return this.rows.size() == 0 ? 0 : this.rows.get(0).getWidth();
    }

    public List<MixedDataRow> getData() {
        return this.rows;
    }

    public MixedDataRow getDataRow(int i) {
        return this.rows.get(i);
    }

    public void setTypes(List<StringUtil.TYPES> t) {
        this.types = t;
    }

    public void setColumnNames(List<String> c) {
        for (String s : c) {
            this.columnNames.add(s);
        }
    }

    public void addColumnName(String n) {
        this.columnNames.add(n);
    }

    public void setData(List<MixedDataRow> d) {
        this.rows = d;
    }

    public void calculateRanges() {
        int i;
        if (!this.ranges.isEmpty()) {
            return;
        }
        int nRows = this.rows.size() - 1;
        if (nRows <= 0) {
            return;
        }
        int nCols = this.getWidth();
        double[] mins = new double[nCols];
        double[] maxs = new double[nCols];
        for (i = 0; i < nCols; ++i) {
            mins[i] = Double.MAX_VALUE;
            maxs[i] = Double.MIN_VALUE;
        }
        for (int row = 0; row < nRows; ++row) {
            MixedDataRow aRow = this.rows.get(row);
            for (int i2 = 0; i2 < nCols; ++i2) {
                Double s = aRow.get(i2).get();
                mins[i2] = Math.min(mins[i2], s);
                maxs[i2] = Math.max(maxs[i2], s);
            }
        }
        for (i = 0; i < nCols; ++i) {
            Range r = mins[i] < maxs[i] ? new Range(mins[i], maxs[i]) : null;
            this.ranges.add(r);
        }
    }

    public void generateHistograms() {
        if (!this.histograms.isEmpty()) {
            return;
        }
        int nRows = this.rows.size() - 1;
        if (nRows <= 0) {
            return;
        }
        int nCols = this.columnNames.size();
        Histogram1D hist = null;
        for (int i = 0; i < nCols; ++i) {
            Range r = this.ranges.get(i);
            if (r != null) {
                hist = new Histogram1D(this.columnNames.get(i), this.ranges.get(i));
                for (int row = 0; row < nRows; ++row) {
                    MixedDataRow aRow = this.rows.get(row);
                    Double s = aRow.get(i).get();
                    hist.count(s);
                }
            }
            if (hist == null) continue;
            this.histograms.put(hist.getName(), hist);
            System.out.println(hist.getName() + " has area: " + hist.getArea() + " / " + this.rows.size());
        }
    }

    public Histogram1D getGatedHistogram(GraphRequest req) {
        return this.getGatedHistogram(req.getX(), req.getPopulation());
    }

    public Histogram1D getGatedHistogram(String dimName, String popName) {
        Map<String, Histogram1D> gatedHistograms = this.gatedHistogramMap.get(popName);
        if (gatedHistograms == null) {
            gatedHistograms = this.histograms;
        }
        if (gatedHistograms == null) {
            return null;
        }
        return gatedHistograms.get(dimName);
    }

    public List<Point2D> getPointList(String popName, String xDim, String yDim) {
        ArrayList<Point2D> pointList = new ArrayList<Point2D>();
        int index = 0;
        if (index >= 0) {
            int xIdx = this.indexOf(xDim);
            int yIdx = this.indexOf(yDim);
            for (MixedDataRow aRow : this.rows) {
                Double gate = aRow.get(index).get();
                if (gate != 1.0) continue;
                Point2D pt = new Point2D(aRow.get(xIdx).doubleValue(), aRow.get(yIdx).doubleValue());
                pointList.add(pt);
            }
        }
        return pointList;
    }

    int indexOf(String s) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (!s.equals(this.columnNames.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void calculateStats() {
        int nCols = this.getWidth();
        for (int i = 0; i < nCols; ++i) {
            String status = this.columnNames.get(i) + " has range: " + this.ranges.get(i);
            Histogram1D h = this.histograms.get(i);
            if (h == null) continue;
            double area = h.getArea();
            double gutter = h.getGutterCount();
            String string = status + " Gutter: " + (int)gutter + " / " + (int)area;
        }
    }

    public void populateCSVTable(TableView<MixedDataRow> tableview) {
        tableview.getColumns().clear();
        tableview.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        int idx = 0;
        for (String name : this.getColumnNames()) {
            TableColumn newColumn = new TableColumn(name);
            int j = idx++;
            newColumn.setCellValueFactory(cellData -> ((MixedDataRow)cellData.getValue()).get(j).asObject());
            tableview.getColumns().add((Object)newColumn);
        }
        tableview.getItems().clear();
        int nCols = tableview.getColumns().size();
        int nRows = this.getData().size();
        for (int row = 0; row < nRows; ++row) {
            MixedDataRow newRow = new MixedDataRow(nCols);
            newRow.setRowNum(row);
            for (int i = 1; i < nCols; ++i) {
                Double k = this.getDataRow(row).get(i - 1).get();
                newRow.set(i - 1, k);
            }
            tableview.getItems().add((Object)newRow);
        }
    }

    public void makeGatedHistogramOverlay(Histogram1D histo, OverlaidLineChart peakFitChart, double offsetIncrement, String ... pops) {
        if (peakFitChart != null && histo != null) {
            double yOffset = 0.0;
            String histoName = histo.getName();
            double area = histo.getArea();
            for (String popName : pops) {
                yOffset += offsetIncrement;
                Histogram1D gatedHistogram = this.getGatedHistogram(histoName, popName);
                if (gatedHistogram == null) continue;
                peakFitChart.getData().add(gatedHistogram.getDataSeries(popName, yOffset, area));
            }
        }
    }

    public XYChart.Series<Number, Number> generateData(String xParm, String yParm) {
        List<Double> xVals = this.getColumnValues(xParm);
        List<Double> yVals = this.getColumnValues(yParm);
        if (xVals == null || yVals == null) {
            return null;
        }
        XYChart.Series series1 = new XYChart.Series();
        series1.setName(xParm + " / " + yParm);
        ObservableList dataList = series1.getData();
        int nRows = xVals.size();
        for (int i = 0; i < nRows; ++i) {
            XYChart.Data dataVal = new XYChart.Data((Object)xVals.get(i), (Object)yVals.get(i));
            dataList.add(dataVal);
        }
        return series1;
    }

    int findColumn(String col) {
        if (col != null) {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                if (!col.equals(this.columnNames.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private List<Double> getColumnValues(String parm) {
        int index = this.findColumn(parm);
        if (index < 0) {
            return null;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        List<MixedDataRow> rows = this.getData();
        for (MixedDataRow row : rows) {
            values.add(row.get(index).doubleValue());
        }
        return values;
    }
}

