/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal.charts.oneD;

import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.util.Pair;
import org.cytoscape.cyChart.internal.model.Peak;

public class OverlaidLineChart
extends LineChart<Number, Number> {
    private ObservableList<XYChart.Data<Number, Number>> verticalMarkers = FXCollections.observableArrayList();
    private ObservableList<Peak> bellCurveMarkers = FXCollections.observableArrayList();

    public OverlaidLineChart(Axis<Number> xAxis, Axis<Number> yAxis) {
        super(xAxis, yAxis);
    }

    public void addVerticalValueMarker(XYChart.Data<Number, Number> marker, Color c, double strokeWid) {
        Objects.requireNonNull(marker, "the marker must not be null");
        if (this.verticalMarkers.contains(marker)) {
            return;
        }
        Line line = new Line();
        line.setStroke((Paint)c);
        line.setStrokeWidth(strokeWid);
        marker.setNode((Node)line);
        this.getPlotChildren().add((Object)line);
        this.verticalMarkers.add(marker);
    }

    public void removeVerticalValueMarker(XYChart.Data<Number, Number> marker) {
        Objects.requireNonNull(marker, "the marker must not be null");
        if (marker.getNode() != null) {
            this.getPlotChildren().remove((Object)marker.getNode());
            marker.setNode(null);
        }
        this.verticalMarkers.remove(marker);
    }

    public void addBellCurveMarker(Peak peak, Color c, double strokeWid) {
        Objects.requireNonNull(peak, "the peak must not be null");
        if (this.bellCurveMarkers.contains((Object)peak)) {
            return;
        }
        Path line = peak.getPath();
        line.setStroke((Paint)c);
        line.setStrokeWidth(strokeWid);
        peak.setNode((Node)line);
        this.getPlotChildren().add((Object)line);
        this.bellCurveMarkers.add((Object)peak);
    }

    public void removeBellCurveMarker(XYChart.Data<Number, Number> marker) {
        Objects.requireNonNull(marker, "the marker must not be null");
        if (marker.getNode() != null) {
            this.getPlotChildren().remove((Object)marker.getNode());
            marker.setNode(null);
        }
        this.bellCurveMarkers.remove(marker);
    }

    protected void layoutPlotChildren() {
        super.layoutPlotChildren();
        for (XYChart.Data verticalMarker : this.verticalMarkers) {
            double lower = ((NumberAxis)this.getYAxis()).getLowerBound();
            Number lowerY = (Number)this.getYAxis().toRealValue(lower);
            double upper = ((NumberAxis)this.getYAxis()).getUpperBound();
            Number upperY = (Number)this.getYAxis().toRealValue(upper);
            Line line = (Line)verticalMarker.getNode();
            line.setStartY(this.getYAxis().getDisplayPosition((Object)lowerY));
            line.setEndY(this.getYAxis().getDisplayPosition((Object)upperY));
            line.setStartX(this.getXAxis().getDisplayPosition((Object)((Number)verticalMarker.getXValue())));
            line.setEndX(line.getStartX());
        }
        for (Peak curve : this.bellCurveMarkers) {
            Path path = curve.getPath();
            path.setStroke((Paint)Color.BLUE);
            path.setStrokeWidth(2.0);
            curve.setNode((Node)path);
        }
    }

    private int getDataSize() {
        ObservableList data = this.getData();
        return data != null ? data.size() : 0;
    }

    private static void smooth(ObservableList<PathElement> strokeElements, ObservableList<PathElement> fillElements) {
        Point2D[] dataPoints = new Point2D[strokeElements.size()];
        for (int i = 0; i < strokeElements.size(); ++i) {
            PathElement element = (PathElement)strokeElements.get(i);
            if (element instanceof MoveTo) {
                MoveTo move = (MoveTo)element;
                dataPoints[i] = new Point2D(move.getX(), move.getY());
                continue;
            }
            if (!(element instanceof LineTo)) continue;
            LineTo line = (LineTo)element;
            double x = line.getX();
            double y = line.getY();
            dataPoints[i] = new Point2D(x, y);
        }
        double zeroY = ((MoveTo)strokeElements.get(0)).getY();
        strokeElements.clear();
        fillElements.clear();
        Pair<Point2D[], Point2D[]> result = OverlaidLineChart.calcCurveControlPoints(dataPoints);
        if (result == null) {
            return;
        }
        Point2D[] pts1 = (Point2D[])result.getKey();
        Point2D[] pts2 = (Point2D[])result.getValue();
        strokeElements.add((Object)new MoveTo(dataPoints[0].getX(), dataPoints[0].getY()));
        fillElements.add((Object)new MoveTo(dataPoints[0].getX(), zeroY));
        fillElements.add((Object)new LineTo(dataPoints[0].getX(), dataPoints[0].getY()));
        for (int i = 1; i < dataPoints.length; ++i) {
            strokeElements.add((Object)OverlaidLineChart.makeCubicCurveTo(pts1[i - 1], pts2[i - 1], dataPoints[i]));
            fillElements.add((Object)OverlaidLineChart.makeCubicCurveTo(pts1[i - 1], pts2[i - 1], dataPoints[i]));
        }
        fillElements.add((Object)new LineTo(dataPoints[dataPoints.length - 1].getX(), zeroY));
        fillElements.add((Object)new ClosePath());
    }

    private static PathElement makeCubicCurveTo(Point2D a, Point2D b, Point2D c) {
        return new CubicCurveTo(a.getX(), a.getY(), b.getX(), b.getY(), c.getX(), c.getY());
    }

    public static Pair<Point2D[], Point2D[]> calcCurveControlPoints(Point2D[] dataPoints) {
        if (dataPoints == null || dataPoints.length == 0) {
            return null;
        }
        int n = dataPoints.length - 1;
        if (n == 1) {
            Point2D[] firstControlPoints = new Point2D[]{new Point2D((2.0 * dataPoints[0].getX() + dataPoints[1].getX()) / 3.0, (2.0 * dataPoints[0].getY() + dataPoints[1].getY()) / 3.0)};
            Point2D[] secondControlPoints = new Point2D[]{new Point2D(2.0 * firstControlPoints[0].getX() - dataPoints[0].getX(), 2.0 * firstControlPoints[0].getY() - dataPoints[0].getY())};
            return new Pair((Object)firstControlPoints, (Object)secondControlPoints);
        }
        double[] rhs = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * dataPoints[i].getX() + 2.0 * dataPoints[i + 1].getX();
        }
        rhs[0] = dataPoints[0].getX() + 2.0 * dataPoints[1].getX();
        rhs[n - 1] = (8.0 * dataPoints[n - 1].getX() + dataPoints[n].getX()) / 2.0;
        double[] x = OverlaidLineChart.GetFirstControlPoints(rhs);
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * dataPoints[i].getY() + 2.0 * dataPoints[i + 1].getY();
        }
        rhs[0] = dataPoints[0].getY() + 2.0 * dataPoints[1].getY();
        rhs[n - 1] = (8.0 * dataPoints[n - 1].getY() + dataPoints[n].getY()) / 2.0;
        double[] y = OverlaidLineChart.GetFirstControlPoints(rhs);
        Point2D[] firstControlPoints = new Point2D[n];
        Point2D[] secondControlPoints = new Point2D[n];
        for (int i = 0; i < n; ++i) {
            firstControlPoints[i] = new Point2D(x[i], y[i]);
            secondControlPoints[i] = i < n - 1 ? new Point2D(2.0 * dataPoints[i + 1].getX() - x[i + 1], 2.0 * dataPoints[i + 1].getY() - y[i + 1]) : new Point2D((dataPoints[n].getX() + x[n - 1]) / 2.0, (dataPoints[n].getY() + y[n - 1]) / 2.0);
        }
        return new Pair((Object)firstControlPoints, (Object)secondControlPoints);
    }

    private static double[] GetFirstControlPoints(double[] rhs) {
        int i;
        int n = rhs.length;
        double[] x = new double[n];
        double[] tmp = new double[n];
        double b = 2.0;
        x[0] = rhs[0] / b;
        for (i = 1; i < n; ++i) {
            tmp[i] = 1.0 / b;
            b = (i < n - 1 ? 4.0 : 3.5) - tmp[i];
            x[i] = (rhs[i] - x[i - 1]) / b;
        }
        for (i = 1; i < n; ++i) {
            int n2 = n - i - 1;
            x[n2] = x[n2] - tmp[n - i] * x[n - i];
        }
        return x;
    }
}

