/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyChart.internal;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.TextField;
import org.cytoscape.cyChart.internal.charts.AbstractChartController;

public class NumberField
extends TextField {
    private final NumberFormat nf;
    private ObjectProperty<BigDecimal> number = new SimpleObjectProperty();
    AbstractChartController controller;

    public final BigDecimal getNumber() {
        return (BigDecimal)this.number.get();
    }

    public final void setNumber(BigDecimal value) {
        this.number.set((Object)value);
    }

    public final void setNumber(double value) {
        this.number.set((Object)new BigDecimal(value));
    }

    public ObjectProperty<BigDecimal> numberProperty() {
        return this.number;
    }

    public NumberField(AbstractChartController contrl) {
        this(BigDecimal.ZERO, contrl);
    }

    public NumberField(BigDecimal value, AbstractChartController contrl) {
        this(value, NumberFormat.getInstance(), contrl);
        this.initHandlers();
    }

    public NumberField(BigDecimal value, NumberFormat nf, AbstractChartController contrl) {
        this.nf = nf;
        this.controller = contrl;
        this.setStyle(this.getStyle() + "-fx-text-alignment:RIGHT;");
        this.initHandlers();
        this.setNumber(value);
    }

    private void initHandlers() {
        this.setOnAction(arg0 -> this.parseAndFormatInput());
        this.focusedProperty().addListener((obs, old, nVal) -> {
            if (!nVal.booleanValue()) {
                this.parseAndFormatInput();
            }
        });
        this.numberProperty().addListener((obs, old, nVal) -> this.textChanged((BigDecimal)nVal));
        this.setOnKeyTyped(event -> {
            if (event.getCharacter().isEmpty()) {
                return;
            }
            char c = event.getCharacter().charAt(0);
            if (!Character.isDigit(c) && c != '\t' && '.' != c) {
                event.consume();
            }
        });
    }

    private void textChanged(BigDecimal nVal) {
        String str = this.nf.format(nVal);
        this.setText(str);
        this.controller.fieldChanged(str, this.getId());
    }

    private void parseAndFormatInput() {
        try {
            String input = this.getText();
            if (input == null || input.length() == 0) {
                return;
            }
            Number parsedNumber = this.nf.parse(input);
            BigDecimal newValue = new BigDecimal(parsedNumber.toString());
            this.setNumber(newValue);
            this.controller.fieldEdited(this.getId(), newValue);
            this.selectAll();
        }
        catch (ParseException ex) {
            this.setText(this.nf.format(this.number.get()));
        }
    }
}

