/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.view;

import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupSettingsManager;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.task.AbstractNodeViewTask;
import org.cytoscape.task.AbstractNodeViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class GroupViewDoubleClickListener
extends AbstractNodeViewTaskFactory {
    final CyGroupManagerImpl cyGroupManager;
    final CyGroupSettingsImpl cyGroupSettings;

    public GroupViewDoubleClickListener(CyGroupManagerImpl groupManager, CyGroupSettingsImpl groupSettings) {
        this.cyGroupManager = groupManager;
        this.cyGroupSettings = groupSettings;
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView networkView) {
        CyNode node = (CyNode)nodeView.getModel();
        CyNetwork net = (CyNetwork)networkView.getModel();
        CyGroup group = null;
        if (this.cyGroupManager.isGroup(node, net)) {
            group = this.cyGroupManager.getGroup(node, net);
        } else {
            List<CyGroup> groups = this.cyGroupManager.getGroupsForNode(node);
            for (CyGroup g : groups) {
                if (!this.cyGroupManager.isGroup(g.getGroupNode(), net)) continue;
                group = g;
                break;
            }
        }
        CyGroupSettingsManager.DoubleClickAction action = this.cyGroupSettings.getDoubleClickAction(group);
        if (action == CyGroupSettingsManager.DoubleClickAction.EXPANDCONTRACT) {
            return new TaskIterator(new Task[]{new CollapseGroupTask(nodeView, networkView)});
        }
        if (action == CyGroupSettingsManager.DoubleClickAction.SELECT) {
            return new TaskIterator(new Task[]{new SelectGroupTask(nodeView, networkView)});
        }
        return new TaskIterator(new Task[]{new NullTask()});
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView networkView) {
        CyNetwork net;
        CyNode node = (CyNode)nodeView.getModel();
        if (this.cyGroupManager.isGroup(node, net = (CyNetwork)networkView.getModel())) {
            return true;
        }
        List<CyGroup> groups = this.cyGroupManager.getGroupsForNode(node);
        for (CyGroup g : groups) {
            if (!this.cyGroupManager.isGroup(g.getGroupNode(), net)) continue;
            return true;
        }
        return false;
    }

    String getGroupName(CyGroup group) {
        CyRootNetwork rootNetwork = group.getRootNetwork();
        String name = (String)rootNetwork.getRow((CyIdentifiable)group.getGroupNode(), "SHARED_ATTRS").get("shared name", String.class);
        return name;
    }

    String getName(CyNode node, CyNetwork network) {
        String name = (String)network.getRow((CyIdentifiable)node).get("name", String.class);
        return name;
    }

    class CollapseGroupTask
    extends AbstractNodeViewTask {
        public CollapseGroupTask(View<CyNode> nodeView, CyNetworkView networkView) {
            super(nodeView, networkView);
        }

        public void run(TaskMonitor tm) throws Exception {
            CyNetwork network = (CyNetwork)this.netView.getModel();
            CyNode node = (CyNode)this.nodeView.getModel();
            tm.setProgress(0.0);
            if (GroupViewDoubleClickListener.this.cyGroupManager.isGroup(node, network)) {
                CyGroup group = GroupViewDoubleClickListener.this.cyGroupManager.getGroup(node, network);
                String name = GroupViewDoubleClickListener.this.getGroupName(group);
                if (group.isCollapsed(network)) {
                    tm.setTitle("Expanding group \"" + name + "\"");
                    group.expand(network);
                } else {
                    tm.setTitle("Collapsing group \"" + name + "\"");
                    group.collapse(network);
                }
            } else {
                List<CyGroup> groups = GroupViewDoubleClickListener.this.cyGroupManager.getGroupsForNode(node);
                if (groups != null && groups.size() > 0) {
                    CyGroup group = groups.get(0);
                    String name = GroupViewDoubleClickListener.this.getName(node, network);
                    tm.setTitle("Collapsing group for node \"" + name + "\"");
                    group.collapse(network);
                }
            }
            tm.setProgress(1.0);
        }
    }

    class SelectGroupTask
    extends AbstractNodeViewTask {
        public SelectGroupTask(View<CyNode> nodeView, CyNetworkView networkView) {
            super(nodeView, networkView);
        }

        public void run(TaskMonitor tm) throws Exception {
            CyNode node = (CyNode)this.nodeView.getModel();
            CyNetwork network = (CyNetwork)this.netView.getModel();
            CyTable nodeTable = network.getDefaultNodeTable();
            tm.setProgress(0.0);
            List<CyGroup> groups = GroupViewDoubleClickListener.this.cyGroupManager.getGroupsForNode(node);
            if (groups != null && groups.size() > 0) {
                for (CyGroup group : groups) {
                    if (this.allSelected(group, nodeTable)) {
                        for (CyNode member : group.getNodeList()) {
                            nodeTable.getRow((Object)member.getSUID()).set("selected", (Object)Boolean.FALSE);
                        }
                        continue;
                    }
                    for (CyNode member : group.getNodeList()) {
                        nodeTable.getRow((Object)member.getSUID()).set("selected", (Object)Boolean.TRUE);
                    }
                }
            }
            tm.setProgress(1.0);
        }

        private boolean allSelected(CyGroup group, CyTable nodeTable) {
            for (CyNode node : group.getNodeList()) {
                Boolean sel = (Boolean)nodeTable.getRow((Object)node.getSUID()).get("selected", Boolean.class);
                if (sel.booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    class NullTask
    extends AbstractTask {
        NullTask() {
        }

        public void run(TaskMonitor tm) throws Exception {
        }
    }
}

