/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import java.util.ArrayList;
import java.util.Arrays;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class LongAggregator
extends AbstractAggregator {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.AVG, AttributeHandlingType.MIN, AttributeHandlingType.MAX, AttributeHandlingType.MEDIAN, AttributeHandlingType.SUM};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new LongAggregator(t));
            }
        }
        registered = true;
    }

    public LongAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class getSupportedType() {
        return Long.class;
    }

    public Long aggregate(CyTable table, CyGroup group, CyColumn column) {
        double aggregation = 0.0;
        int count = 0;
        ArrayList<Long> valueList = null;
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        switch (this.type) {
            case MAX: {
                aggregation = -9.223372036854776E18;
                break;
            }
            case MIN: {
                aggregation = 9.223372036854776E18;
                break;
            }
            case MEDIAN: {
                valueList = new ArrayList<Long>();
            }
        }
        for (CyNode node : group.getNodeList()) {
            Long v = (Long)table.getRow((Object)node.getSUID()).get(column.getName(), Long.class);
            if (v == null) continue;
            ++count;
            double value = v.doubleValue();
            switch (this.type) {
                case MAX: {
                    if (!(aggregation < value)) break;
                    aggregation = value;
                    break;
                }
                case MIN: {
                    if (!(aggregation > value)) break;
                    aggregation = value;
                    break;
                }
                case SUM: {
                    aggregation += value;
                    break;
                }
                case AVG: {
                    aggregation += value;
                    break;
                }
                case MEDIAN: {
                    valueList.add((long)value);
                }
            }
        }
        if (this.type == AttributeHandlingType.MEDIAN) {
            Object[] vArray = new Long[valueList.size()];
            vArray = valueList.toArray(vArray);
            Arrays.sort(vArray);
            aggregation = vArray.length % 2 == 1 ? (double)((Long)vArray[(vArray.length - 1) / 2]).longValue() : (double)(((Long)vArray[vArray.length / 2 - 1] + (Long)vArray[vArray.length / 2]) / 2L);
        } else if (this.type == AttributeHandlingType.AVG) {
            aggregation /= (double)count;
        }
        Long v = new Long((long)aggregation);
        table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), (Object)v);
        return v;
    }
}

