/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data.aggregators;

import java.util.ArrayList;
import java.util.Arrays;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.data.AttributeHandlingType;
import org.cytoscape.group.data.CyGroupAggregationManager;
import org.cytoscape.group.internal.data.aggregators.AbstractAggregator;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class DoubleAggregator
extends AbstractAggregator {
    static AttributeHandlingType[] supportedTypes = new AttributeHandlingType[]{AttributeHandlingType.NONE, AttributeHandlingType.AVG, AttributeHandlingType.MIN, AttributeHandlingType.MAX, AttributeHandlingType.MEDIAN, AttributeHandlingType.SUM};
    static boolean registered = false;

    public static void registerAggregators(CyGroupAggregationManager mgr) {
        if (!registered) {
            for (AttributeHandlingType t : supportedTypes) {
                mgr.addAggregator((Aggregator)new DoubleAggregator(t));
            }
        }
        registered = true;
    }

    public DoubleAggregator(AttributeHandlingType type) {
        this.type = type;
    }

    public Class getSupportedType() {
        return Double.class;
    }

    public Double aggregate(CyTable table, CyGroup group, CyColumn column) {
        double aggregation = 0.0;
        int count = 0;
        ArrayList<Double> valueList = null;
        if (this.type == AttributeHandlingType.NONE) {
            return null;
        }
        switch (this.type) {
            case MAX: {
                aggregation = Double.MIN_VALUE;
                break;
            }
            case MIN: {
                aggregation = Double.MAX_VALUE;
                break;
            }
            case MEDIAN: {
                valueList = new ArrayList<Double>();
            }
        }
        for (CyNode node : group.getNodeList()) {
            Double v = (Double)table.getRow((Object)node.getSUID()).get(column.getName(), Double.class);
            if (v == null) continue;
            double value = v;
            ++count;
            switch (this.type) {
                case MAX: {
                    if (!(aggregation < value)) break;
                    aggregation = value;
                    break;
                }
                case MIN: {
                    if (!(aggregation > value)) break;
                    aggregation = value;
                    break;
                }
                case SUM: {
                    aggregation += value;
                    break;
                }
                case AVG: {
                    aggregation += value;
                    break;
                }
                case MEDIAN: {
                    valueList.add(value);
                }
            }
        }
        if (this.type == AttributeHandlingType.MEDIAN) {
            Object[] vArray = new Double[valueList.size()];
            vArray = valueList.toArray(vArray);
            Arrays.sort(vArray);
            aggregation = vArray.length % 2 == 1 ? (Double)vArray[(vArray.length - 1) / 2] : ((Double)vArray[vArray.length / 2 - 1] + (Double)vArray[vArray.length / 2]) / 2.0;
        } else if (this.type == AttributeHandlingType.AVG) {
            aggregation /= (double)count;
        }
        Double v = new Double(aggregation);
        table.getRow((Object)group.getGroupNode().getSUID()).set(column.getName(), (Object)v);
        return v;
    }
}

