/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal.data;

import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.group.data.Aggregator;
import org.cytoscape.group.events.GroupAboutToCollapseEvent;
import org.cytoscape.group.events.GroupAboutToCollapseListener;
import org.cytoscape.group.internal.data.CyGroupSettingsImpl;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDataCollapseHandler
implements GroupAboutToCollapseListener {
    private final CyGroupManager cyGroupManager;
    private final CyGroupSettingsImpl cyGroupSettings;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public GroupDataCollapseHandler(CyGroupManager groupManager, CyGroupSettingsImpl groupSettings) {
        this.cyGroupManager = groupManager;
        this.cyGroupSettings = groupSettings;
    }

    public void handleEvent(GroupAboutToCollapseEvent e) {
        CyNetwork network = e.getNetwork();
        CyGroup group = (CyGroup)e.getSource();
        if (e.collapsing()) {
            if (!this.cyGroupSettings.getEnableAttributeAggregation(group)) {
                return;
            }
            CyTable nodeTable = network.getDefaultNodeTable();
            for (CyColumn column : nodeTable.getColumns()) {
                Aggregator<?> agg;
                Class type = column.getType();
                if (column.isPrimaryKey() || "__AggregationSettings".equals(column.getName()) || "__AggregationOverrideSettings".equals(column.getName()) || "__ViewSettings".equals(column.getName()) || "NumChildren".equals(column.getName()) || "NumDescendents".equals(column.getName()) || "name".equals(column.getName()) && !this.haveOverride(group, column) || "shared name".equals(column.getName()) && !this.haveOverride(group, column) || (agg = this.cyGroupSettings.getAggregator(group, column)) == null) continue;
                agg.aggregate(nodeTable, group, column);
            }
        }
    }

    private boolean haveOverride(CyGroup group, CyColumn column) {
        if (this.cyGroupSettings.getOverrideAggregation(group, column) == null) {
            return false;
        }
        Aggregator<?> agg = this.cyGroupSettings.getOverrideAggregation(group, column);
        return !agg.toString().equals("None");
    }
}

