/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.group.internal.GroupUtil;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;

public class LockedVisualPropertiesManager {
    private final Map<Key, Map<VisualProperty<?>, Object>> bypassMap;
    private final CyServiceRegistrar serviceRegistrar;

    public LockedVisualPropertiesManager(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.bypassMap = new HashMap();
    }

    public void saveLockedValues(CyIdentifiable element, Collection<CyNetworkView> netViewList) {
        if (element == null || netViewList == null) {
            return;
        }
        for (CyNetworkView netView : netViewList) {
            View<? extends CyIdentifiable> view = GroupUtil.getView(netView, element);
            if (view == null) continue;
            Collection<VisualProperty<?>> visualProps = this.getSupportedVisualProperties(netView);
            HashMap lockedValues = new HashMap();
            for (VisualProperty<?> vp : visualProps) {
                if (!vp.getTargetDataType().isAssignableFrom(element.getClass()) || !view.isValueLocked(vp)) continue;
                lockedValues.put(vp, view.getVisualProperty(vp));
            }
            this.add(element, netView, lockedValues);
        }
    }

    public void setLockedValues(Collection<CyNetworkView> netViewList, Set<CyIdentifiable> elements) {
        for (CyNetworkView netView : netViewList) {
            for (CyIdentifiable element : elements) {
                Key key;
                Map<VisualProperty<?>, Object> lockedValues;
                View<? extends CyIdentifiable> view = GroupUtil.getView(netView, element);
                if (view == null || (lockedValues = this.bypassMap.get(key = new Key(netView, element))) == null) continue;
                for (Map.Entry<VisualProperty<?>, Object> entry : lockedValues.entrySet()) {
                    view.setLockedValue(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public Map<Key, Map<VisualProperty<?>, Object>> getLockedVisualPropertiesMap() {
        return new HashMap(this.bypassMap);
    }

    public void addAll(Map<Key, Map<VisualProperty<?>, Object>> map) {
        this.bypassMap.putAll(map);
    }

    public void add(CyIdentifiable element, CyNetworkView netView, Map<VisualProperty<?>, Object> lockedValues) {
        if (element != null && netView != null) {
            Key key = new Key(netView, element);
            this.add(key, lockedValues);
        }
    }

    public void add(Key key, Map<VisualProperty<?>, Object> lockedValues) {
        if (key != null) {
            if (lockedValues == null || lockedValues.isEmpty()) {
                this.bypassMap.remove(key);
            } else {
                this.bypassMap.put(key, lockedValues);
            }
        }
    }

    public void reset() {
        this.bypassMap.clear();
    }

    private Collection<VisualProperty<?>> getSupportedVisualProperties(CyNetworkView netView) {
        HashSet props = new HashSet();
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        Set allLexicons = vmMgr.getAllVisualLexicon();
        if (allLexicons != null && !allLexicons.isEmpty()) {
            VisualLexicon lexicon = (VisualLexicon)vmMgr.getAllVisualLexicon().iterator().next();
            props.addAll(lexicon.getAllDescendants(BasicVisualLexicon.NODE));
            props.addAll(lexicon.getAllDescendants(BasicVisualLexicon.EDGE));
        }
        return props;
    }

    public static class Key {
        private final CyNetworkView networkView;
        private final CyIdentifiable element;

        Key(CyNetworkView networkView, CyIdentifiable element) {
            this.networkView = networkView;
            this.element = element;
        }

        public CyNetworkView getNetworkView() {
            return this.networkView;
        }

        public CyIdentifiable getElement() {
            return this.element;
        }

        public int hashCode() {
            int prime = 27;
            int result = 1;
            result = 27 * result + (this.element == null ? 0 : this.element.hashCode());
            result = 27 * result + (this.networkView == null ? 0 : this.networkView.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
                return false;
            }
            return !(this.networkView == null ? other.networkView != null : !this.networkView.equals(other.networkView));
        }
    }
}

