/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.events.GroupAboutToBeRemovedEvent;
import org.cytoscape.group.events.GroupAboutToCollapseEvent;
import org.cytoscape.group.events.GroupAddedToNetworkEvent;
import org.cytoscape.group.events.GroupCollapsedEvent;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.LockedVisualPropertiesManager;
import org.cytoscape.group.internal.ModelUtils;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyGroupImpl
implements CyGroup {
    public static final String CHILDREN_ATTR = "NumChildren";
    public static final String DESCENDENTS_ATTR = "NumDescendents";
    public static final String ISMETA_EDGE_ATTR = "__isMetaEdge";
    private final CyEventHelper cyEventHelper;
    private final CyGroupManagerImpl mgr;
    private final LockedVisualPropertiesManager lvpMgr;
    private CyNode groupNode;
    private Set<CyEdge> externalEdges;
    private Map<CyEdge, CyEdge> metaEdges;
    private Set<CyEdge> memberEdges;
    private CyRootNetwork rootNetwork = null;
    private Set<CyNetwork> networkSet = null;
    private Set<Long> collapseSet = null;
    private Set<Long> nodeShownSet = null;
    private Map<Long, List<CyNode>> collapsedNodes = null;
    private Set<CyEdge> externalEdgeProcessed = null;
    private Set<CyEdge> groupNodeEdges = null;
    private boolean nodeProvided = false;
    private boolean collapsing = false;
    private boolean expanding = false;
    private boolean neverCollapsed = true;
    private Map<Long, Map<CyIdentifiable, Map<String, Object>>> savedLocalValuesMap;
    private Map<Long, Map<CyIdentifiable, Map<String, Object>>> savedHiddenValuesMap;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Object lock = new Object();

    CyGroupImpl(CyEventHelper eventHelper, CyGroupManagerImpl mgr, LockedVisualPropertiesManager lvpMgr, CyNetwork network, CyNode node, List<CyNode> nodes, List<CyEdge> edges) {
        this.cyEventHelper = eventHelper;
        this.mgr = mgr;
        this.lvpMgr = lvpMgr;
        this.rootNetwork = ((CySubNetwork)network).getRootNetwork();
        if (node == null) {
            this.groupNode = this.rootNetwork.addNode();
            ModelUtils.createColumnIfNeeded(this.rootNetwork.getTable(CyNode.class, "HIDDEN"), "GroupNodeProvided", Boolean.class);
            this.rootNetwork.getRow((CyIdentifiable)this.groupNode, "HIDDEN").set("GroupNodeProvided", (Object)false);
        } else {
            this.groupNode = node;
            CySubNetwork nPointer = (CySubNetwork)this.groupNode.getNetworkPointer();
            Boolean nProvided = null;
            if (this.rootNetwork.getTable(CyNode.class, "HIDDEN").getColumn("GroupNodeProvided") != null && this.rootNetwork.getRow((CyIdentifiable)this.groupNode, "HIDDEN") != null) {
                nProvided = (Boolean)this.rootNetwork.getRow((CyIdentifiable)this.groupNode, "HIDDEN").get("GroupNodeProvided", Boolean.class);
            }
            if (nProvided == null && nPointer != null) {
                this.nodeProvided = false;
                this.neverCollapsed = false;
            } else if (nProvided == null || nProvided.booleanValue()) {
                this.nodeProvided = true;
                this.neverCollapsed = false;
            } else {
                this.nodeProvided = false;
            }
            ModelUtils.createColumnIfNeeded(this.rootNetwork.getTable(CyNode.class, "HIDDEN"), "GroupNodeProvided", Boolean.class);
            this.rootNetwork.getRow((CyIdentifiable)this.groupNode, "HIDDEN").set("GroupNodeProvided", (Object)this.nodeProvided);
        }
        this.externalEdges = new HashSet<CyEdge>();
        this.metaEdges = new HashMap<CyEdge, CyEdge>();
        this.memberEdges = new HashSet<CyEdge>();
        this.networkSet = new HashSet<CyNetwork>();
        this.collapseSet = new HashSet<Long>();
        this.nodeShownSet = new HashSet<Long>();
        this.collapsedNodes = new HashMap<Long, List<CyNode>>();
        this.externalEdgeProcessed = new HashSet<CyEdge>();
        this.groupNodeEdges = new HashSet<CyEdge>();
        this.savedLocalValuesMap = new HashMap<Long, Map<CyIdentifiable, Map<String, Object>>>();
        this.savedHiddenValuesMap = new HashMap<Long, Map<CyIdentifiable, Map<String, Object>>>();
        this.networkSet.add((CyNetwork)this.rootNetwork);
        this.networkSet.add(network);
        if (nodes == null) {
            nodes = new ArrayList<CyNode>();
        }
        HashSet<CyNode> nodeMap = new HashSet<CyNode>(nodes);
        if (edges != null) {
            ArrayList intEdges = new ArrayList();
            Iterator<CyEdge> iterator = edges.iterator();
            while (iterator.hasNext()) {
                CyEdge e = iterator.next();
                if (nodeMap.contains(e.getSource()) && nodeMap.contains(e.getTarget())) {
                    intEdges.add(e);
                    continue;
                }
                if (e.getSource().equals(node) || e.getTarget().equals(node)) {
                    this.memberEdges.add(e);
                    continue;
                }
                this.externalEdges.add(e);
            }
            edges = intEdges;
        } else if (edges == null) {
            edges = new ArrayList<CyEdge>();
            for (CyNode n : nodes) {
                List aEdges = network.getAdjacentEdgeList(n, CyEdge.Type.ANY);
                for (CyEdge e : aEdges) {
                    if (nodeMap.contains(e.getSource()) && nodeMap.contains(e.getTarget())) {
                        edges.add(e);
                        continue;
                    }
                    if (e.getSource().equals(node) || e.getTarget().equals(node)) {
                        this.memberEdges.add(e);
                        continue;
                    }
                    this.externalEdges.add(e);
                }
            }
        }
        CySubNetwork np = (CySubNetwork)this.groupNode.getNetworkPointer();
        if (np != null && edges.size() == 0 && nodes.size() == 0 && np.getRootNetwork().equals(this.rootNetwork)) {
            if (network.containsNode(this.groupNode)) {
                this.collapseSet.add(network.getSUID());
            }
        } else {
            CySubNetwork groupNet = this.rootNetwork.addSubNetwork(nodes, (Iterable)edges);
            this.groupNode.setNetworkPointer((CyNetwork)groupNet);
        }
        this.updateMetaEdges(false);
        this.updateCountAttributes((CyNetwork)this.rootNetwork);
    }

    public CyNode getGroupNode() {
        return this.groupNode;
    }

    public List<CyNode> getNodeList() {
        return this.getGroupNetwork().getNodeList();
    }

    public List<CyEdge> getInternalEdgeList() {
        return this.getGroupNetwork().getEdgeList();
    }

    public Set<CyEdge> getExternalEdgeList() {
        return this.externalEdges;
    }

    public CySubNetwork getGroupNetwork() {
        return (CySubNetwork)this.groupNode.getNetworkPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(CyNode node) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.rootNetwork.containsNode(node)) {
                this.throwIllegalArgumentException("Can only add a node in the same network tree");
            }
            this.getGroupNetwork().addNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternalEdge(CyEdge edge) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.rootNetwork.containsEdge(edge)) {
                this.throwIllegalArgumentException("Can only add an edge in the same network tree");
            }
            this.getGroupNetwork().addEdge(edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addExternalEdge(CyEdge edge) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.rootNetwork.containsEdge(edge)) {
                this.throwIllegalArgumentException("Can only add an edge in the same network tree");
            }
            if (!this.externalEdges.contains(edge)) {
                this.externalEdges.add(edge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberEdge(CyEdge edge) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.rootNetwork.containsEdge(edge)) {
                this.throwIllegalArgumentException("Can only add an edge in the same network tree");
            }
            if (this.groupNode == null) {
                this.throwIllegalArgumentException("Cannot add member edge without a group node");
            }
            if (!edge.getSource().equals(this.groupNode) && !edge.getTarget().equals(this.groupNode)) {
                this.throwIllegalArgumentException("Cannot member edge whose source or target is not the group node");
            }
            if (!this.memberEdges.contains(edge)) {
                this.memberEdges.add(edge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(List<CyNode> nodes) {
        Object object = this.lock;
        synchronized (object) {
            for (CyNode n : nodes) {
                if (!this.rootNetwork.containsNode(n)) {
                    this.throwIllegalArgumentException("Can only add a node in the same network tree");
                }
                this.addNode(n);
                ArrayList adjacentEdges = new ArrayList(this.rootNetwork.getAdjacentEdgeList(n, CyEdge.Type.ANY));
                for (CyEdge edge : adjacentEdges) {
                    CyNode source = edge.getSource();
                    CyNode target = edge.getTarget();
                    if (this.metaEdges.containsValue(edge)) {
                        this.rootNetwork.removeEdges(Collections.singletonList(edge));
                        continue;
                    }
                    if (this.getGroupNetwork().containsNode(source) && this.getGroupNetwork().containsNode(target)) {
                        this.addInternalEdge(edge);
                        if (!this.externalEdges.contains(edge)) continue;
                        this.externalEdges.remove(edge);
                        continue;
                    }
                    if (this.groupNode != null && (source.equals(this.groupNode) || target.equals(this.groupNode)) && !this.isMeta(edge)) {
                        this.addMemberEdge(edge);
                        continue;
                    }
                    this.addExternalEdge(edge);
                }
            }
            this.updateMetaEdges(false);
            for (CyNetwork net : this.networkSet) {
                this.updateCountAttributes(net);
            }
        }
        this.cyEventHelper.flushPayloadEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdges(List<CyEdge> edges) {
        Object object = this.lock;
        synchronized (object) {
            boolean updateMeta = false;
            for (CyEdge edge : edges) {
                CyNode source = edge.getSource();
                CyNode target = edge.getTarget();
                if (this.getGroupNetwork().containsNode(source) && this.getGroupNetwork().containsNode(target)) {
                    this.getGroupNetwork().addEdge(edge);
                    continue;
                }
                if (this.groupNode != null && (source.equals(this.groupNode) || target.equals(this.groupNode)) && !this.isMeta(edge)) {
                    this.memberEdges.add(edge);
                    continue;
                }
                if (!this.getGroupNetwork().containsNode(source) && !this.getGroupNetwork().containsNode(target) || this.metaEdges.containsValue(edge)) continue;
                this.externalEdges.add(edge);
                updateMeta = true;
            }
            if (updateMeta) {
                this.updateMetaEdges(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodes(List<CyNode> nodes) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CyEdge> netEdges = new ArrayList<CyEdge>();
            for (CyNode node : nodes) {
                List edges = this.rootNetwork.getAdjacentEdgeList(node, CyEdge.Type.ANY);
                for (CyEdge edge : edges) {
                    if (this.externalEdges.contains(edge)) {
                        this.externalEdges.remove(edge);
                        continue;
                    }
                    if (this.memberEdges.contains(edge)) {
                        this.memberEdges.remove(edge);
                        continue;
                    }
                    netEdges.add(edge);
                }
            }
            if (netEdges.size() > 0) {
                this.getGroupNetwork().removeEdges(netEdges);
            }
            this.getGroupNetwork().removeNodes(nodes);
            this.updateMetaEdges(false);
            for (CyNetwork net : this.networkSet) {
                this.updateCountAttributes(net);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEdges(List<CyEdge> edges) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<CyEdge> netEdges = new ArrayList<CyEdge>();
            for (CyEdge edge : edges) {
                if (this.getGroupNetwork().containsEdge(edge)) {
                    netEdges.add(edge);
                    continue;
                }
                if (this.externalEdges.contains(edge)) {
                    this.externalEdges.remove(edge);
                    if (!this.metaEdges.containsKey(edge)) continue;
                    this.metaEdges.remove(edge);
                    continue;
                }
                if (this.metaEdges.containsValue(edge)) {
                    this.removeMetaEdge(edge);
                    continue;
                }
                if (!this.memberEdges.contains(edge)) continue;
                this.memberEdges.remove(edge);
            }
            if (netEdges.size() > 0) {
                this.getGroupNetwork().removeEdges(netEdges);
            }
        }
    }

    public CyRootNetwork getRootNetwork() {
        return this.rootNetwork;
    }

    public Set<CyNetwork> getNetworkSet() {
        return this.networkSet;
    }

    public boolean isInNetwork(CyNetwork network) {
        return this.networkSet.contains(network);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupToNetwork(CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.inSameRoot(network)) {
                this.throwIllegalArgumentException("Network not in same root network as group");
            }
            if (!this.networkSet.contains(network)) {
                this.networkSet.add(network);
            }
        }
        this.cyEventHelper.fireEvent((CyEvent)new GroupAddedToNetworkEvent((CyGroup)this, network));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupFromNetwork(CyNetwork network) {
        this.cyEventHelper.fireEvent((CyEvent)new GroupAboutToBeRemovedEvent((CyGroup)this, network));
        Object object = this.lock;
        synchronized (object) {
            if (this.networkSet.contains(network)) {
                this.networkSet.remove(network);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapse(CyNetwork net) {
        ArrayList<CyNode> nodes;
        Object e22;
        CyNetwork groupNet;
        CySubNetwork subnet;
        Iterator<CyEdge> iterator = this.lock;
        synchronized (iterator) {
            if (this.isCollapsed(net)) {
                return;
            }
            if (!this.networkSet.contains(net)) {
                return;
            }
            subnet = (CySubNetwork)net;
            groupNet = this.groupNode.getNetworkPointer();
            for (CyNode node : this.getNodeList()) {
                CyGroup gn;
                if (!this.mgr.isGroup(node, net) || (gn = this.mgr.getGroup(node, net)).isCollapsed(net)) continue;
                gn.collapse(net);
            }
        }
        this.cyEventHelper.fireEvent((CyEvent)new GroupAboutToCollapseEvent((CyGroup)this, net, true));
        this.collapsing = true;
        this.cyEventHelper.silenceEventSource((Object)net.getDefaultNodeTable());
        this.cyEventHelper.silenceEventSource((Object)net.getDefaultEdgeTable());
        iterator = this.lock;
        synchronized (iterator) {
            for (CyNode node : this.getNodeList()) {
                if (!net.containsNode(node)) continue;
                net.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.FALSE);
            }
            for (CyEdge edge : this.getInternalEdgeList()) {
                if (!net.containsEdge(edge)) continue;
                net.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.FALSE);
            }
            for (CyEdge edge : this.memberEdges) {
                if (!net.containsEdge(edge)) continue;
                net.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.FALSE);
            }
        }
        for (Object e22 : this.metaEdges.values()) {
            this.rootNetwork.restoreEdge(e22);
        }
        e22 = this.lock;
        synchronized (e22) {
            ListIterator<CyEdge> iterator2 = new ArrayList<CyEdge>(this.externalEdges).listIterator();
            while (iterator2.hasNext()) {
                CyEdge edge = iterator2.next();
                if (net.containsEdge(edge)) {
                    net.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.FALSE);
                    continue;
                }
                if (this.externalEdgeProcessed.contains(edge)) continue;
                CyNode node = this.getPartner(edge);
                if (!net.containsNode(node) && !this.mgr.getGroupsForNode(node).isEmpty()) {
                    for (CyGroup cyGroup : this.mgr.getGroupsForNode(node)) {
                        if (cyGroup.equals(this)) continue;
                        CyEdge metaEdge = null;
                        metaEdge = this.createMetaEdge(edge, cyGroup.getGroupNode(), this.groupNode);
                        this.addMetaEdge(edge, metaEdge);
                        this.addPartnerMetaEdges(net, edge, cyGroup, metaEdge);
                        ListIterator edgeIterator = new ArrayList(cyGroup.getExternalEdgeList()).listIterator();
                        while (edgeIterator.hasNext()) {
                            CyEdge partnerEdge = (CyEdge)edgeIterator.next();
                            CyEdge partnerMetaEdge = null;
                            if (groupNet.containsNode(partnerEdge.getSource())) {
                                partnerMetaEdge = this.createMetaEdge(partnerEdge, partnerEdge.getTarget(), this.groupNode);
                            } else if (groupNet.containsNode(partnerEdge.getTarget())) {
                                partnerMetaEdge = this.createMetaEdge(partnerEdge, partnerEdge.getSource(), this.groupNode);
                            }
                            if (partnerMetaEdge == null) continue;
                            ((CyGroupImpl)cyGroup).addExternalEdge(partnerMetaEdge);
                        }
                    }
                }
                this.externalEdgeProcessed.add(edge);
            }
            this.cyEventHelper.unsilenceEventSource((Object)net.getDefaultNodeTable());
            this.cyEventHelper.unsilenceEventSource((Object)net.getDefaultEdgeTable());
            nodes = new ArrayList<CyNode>();
            for (CyNode node : this.getNodeList()) {
                if (net.containsNode(node)) {
                    nodes.add(node);
                    continue;
                }
                List<CyGroup> otherGroups = this.mgr.getGroupsForNode(node);
                if (otherGroups == null || otherGroups.size() == 0) continue;
                for (CyGroup group : otherGroups) {
                    if (((CyGroupImpl)group).equals(this)) continue;
                    for (CyEdge edge : groupNet.getAdjacentEdgeList(node, CyEdge.Type.ANY)) {
                        CyEdge metaEdge = this.createMetaEdge(edge, node, this.groupNode);
                        ((CyGroupImpl)group).addExternalEdge(metaEdge);
                    }
                }
            }
            this.collapsedNodes.put(net.getSUID(), nodes);
        }
        this.cyEventHelper.flushPayloadEvents();
        CyNetworkViewManager netViewMgr = this.mgr.getService(CyNetworkViewManager.class);
        Collection netViewList = netViewMgr.getNetworkViews((CyNetwork)subnet);
        for (CyNode n : nodes) {
            this.lvpMgr.saveLockedValues((CyIdentifiable)n, netViewList);
            this.saveLocalAttributes(net, (CyIdentifiable)n);
            for (CyEdge cyEdge : subnet.getAdjacentEdgeList(n, CyEdge.Type.ANY)) {
                this.lvpMgr.saveLockedValues((CyIdentifiable)cyEdge, netViewList);
                this.saveLocalAttributes(net, (CyIdentifiable)cyEdge);
            }
        }
        subnet.removeNodes(nodes);
        for (CyEdge edge : this.externalEdges) {
            subnet.getRootNetwork().restoreEdge(edge);
        }
        HashSet<CyIdentifiable> addedElements = new HashSet<CyIdentifiable>();
        Object object = this.lock;
        synchronized (object) {
            if (net.containsNode(this.groupNode)) {
                this.nodeShownSet.add(net.getSUID());
            }
            if (this.memberEdges.size() == 0 && !this.nodeShownSet.contains(net.getSUID())) {
                subnet.addNode(this.groupNode);
                addedElements.add((CyIdentifiable)this.groupNode);
                for (CyEdge cyEdge : this.groupNodeEdges) {
                    if (subnet.containsEdge(cyEdge)) {
                        this.lvpMgr.saveLockedValues((CyIdentifiable)cyEdge, netViewList);
                        this.saveLocalAttributes(net, (CyIdentifiable)cyEdge);
                        subnet.removeEdges(Collections.singletonList(cyEdge));
                        this.rootNetwork.restoreEdge(cyEdge);
                    }
                    if (!subnet.containsNode(cyEdge.getSource()) || !subnet.containsNode(cyEdge.getTarget())) continue;
                    subnet.addEdge(cyEdge);
                    addedElements.add((CyIdentifiable)cyEdge);
                }
            }
            for (CyEdge cyEdge : this.getMetaEdgeList()) {
                if (subnet.containsEdge(cyEdge) || !subnet.containsNode(cyEdge.getSource()) || !subnet.containsNode(cyEdge.getTarget())) continue;
                subnet.addEdge(cyEdge);
                addedElements.add((CyIdentifiable)cyEdge);
                this.nameMetaEdge(cyEdge, cyEdge.getSource(), cyEdge.getTarget());
                this.copyEdgeName((CyNetwork)subnet, cyEdge);
            }
            this.collapseSet.add(net.getSUID());
            this.updateCountAttributes(net);
        }
        this.cyEventHelper.flushPayloadEvents();
        this.lvpMgr.setLockedValues(netViewList, addedElements);
        this.restoreLocalAttributes(net, addedElements);
        this.collapsing = false;
        this.cyEventHelper.fireEvent((CyEvent)new GroupCollapsedEvent((CyGroup)this, net, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(CyNetwork net) {
        List<CyNode> nodes;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCollapsed(net)) {
                return;
            }
            if (!this.networkSet.contains(net)) {
                return;
            }
        }
        this.cyEventHelper.fireEvent((CyEvent)new GroupAboutToCollapseEvent((CyGroup)this, net, false));
        this.expanding = true;
        CySubNetwork subnet = (CySubNetwork)net;
        Object object2 = this.lock;
        synchronized (object2) {
            nodes = this.collapsedNodes.get(net.getSUID());
            if (nodes == null) {
                nodes = this.getNodeList();
            }
        }
        boolean groupNodeShown = this.nodeShownSet.contains(net.getSUID());
        if (!groupNodeShown && net.containsNode(this.groupNode)) {
            this.cyEventHelper.silenceEventSource((Object)net.getDefaultNodeTable());
            net.getRow((CyIdentifiable)this.groupNode).set("selected", (Object)Boolean.FALSE);
            this.cyEventHelper.unsilenceEventSource((Object)net.getDefaultNodeTable());
        }
        CyNetworkViewManager netViewMgr = this.mgr.getService(CyNetworkViewManager.class);
        Collection netViewList = netViewMgr.getNetworkViews(net);
        HashSet<CyIdentifiable> addedElements = new HashSet<CyIdentifiable>();
        Object object3 = this.lock;
        synchronized (object3) {
            if (this.memberEdges.size() == 0 && !groupNodeShown) {
                List groupEdges = subnet.getAdjacentEdgeList(this.groupNode, CyEdge.Type.ANY);
                this.lvpMgr.saveLockedValues((CyIdentifiable)this.groupNode, netViewList);
                this.saveLocalAttributes(net, (CyIdentifiable)this.groupNode);
                for (CyEdge e : groupEdges) {
                    this.lvpMgr.saveLockedValues((CyIdentifiable)e, netViewList);
                    this.saveLocalAttributes(net, (CyIdentifiable)e);
                }
                this.groupNodeEdges = new HashSet<CyEdge>();
                for (CyEdge edge : groupEdges) {
                    if (this.isMeta(edge)) continue;
                    this.groupNodeEdges.add(edge);
                }
                if (!this.nodeShownSet.contains(subnet.getSUID())) {
                    List groupNodeEdges = subnet.getAdjacentEdgeList(this.groupNode, CyEdge.Type.ANY);
                    subnet.removeNodes(Collections.singletonList(this.groupNode));
                    this.rootNetwork.restoreNode(this.groupNode);
                    for (CyEdge e : groupNodeEdges) {
                        this.rootNetwork.restoreEdge(e);
                    }
                }
            }
            for (CyNode n : nodes) {
                subnet.addNode(n);
                addedElements.add((CyIdentifiable)n);
            }
        }
        this.cyEventHelper.flushPayloadEvents();
        object3 = this.lock;
        synchronized (object3) {
            for (CyEdge e : this.getInternalEdgeList()) {
                if (!subnet.containsNode(e.getSource()) || !subnet.containsNode(e.getTarget())) continue;
                subnet.addEdge(e);
                addedElements.add((CyIdentifiable)e);
            }
            for (CyEdge e : this.getExternalEdgeList()) {
                if (!subnet.containsNode(e.getSource()) || !subnet.containsNode(e.getTarget())) continue;
                subnet.addEdge(e);
                addedElements.add((CyIdentifiable)e);
            }
            for (CyEdge e : this.getMetaEdgeList()) {
                if (!subnet.containsNode(e.getSource()) || !subnet.containsNode(e.getTarget())) continue;
                subnet.addEdge(e);
                addedElements.add((CyIdentifiable)e);
            }
            for (CyEdge e : this.memberEdges) {
                subnet.addEdge(e);
                addedElements.add((CyIdentifiable)e);
            }
        }
        this.cyEventHelper.flushPayloadEvents();
        this.lvpMgr.setLockedValues(netViewList, addedElements);
        this.restoreLocalAttributes(net, addedElements);
        object3 = this.lock;
        synchronized (object3) {
            this.collapseSet.remove(net.getSUID());
            this.collapsedNodes.remove(net.getSUID());
        }
        this.expanding = false;
        this.cyEventHelper.fireEvent((CyEvent)new GroupCollapsedEvent((CyGroup)this, net, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollapsed(CyNetwork net) {
        Object object = this.lock;
        synchronized (object) {
            return this.collapseSet.contains(net.getSUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCollapsed(CyNetwork net, boolean collapsed) {
        Object object = this.lock;
        synchronized (object) {
            if (collapsed && !this.collapseSet.contains(net.getSUID())) {
                this.collapseSet.add(net.getSUID());
            }
            if (!collapsed && this.collapseSet.contains(net.getSUID())) {
                this.collapseSet.remove(net.getSUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupNodeShown(CyNetwork net, boolean showGroupNode) {
        Object object = this.lock;
        synchronized (object) {
            if (showGroupNode && !this.nodeShownSet.contains(net.getSUID())) {
                this.nodeShownSet.add(net.getSUID());
            }
            if (!showGroupNode && this.nodeShownSet.contains(net.getSUID())) {
                this.nodeShownSet.remove(net.getSUID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyGroup() {
        CySubNetwork groupNet = this.getGroupNetwork();
        Object object = this.lock;
        synchronized (object) {
            if (groupNet != null) {
                for (CyNetwork net : this.networkSet) {
                    this.expand(net);
                }
                this.rootNetwork.removeSubNetwork(groupNet);
                this.groupNode.setNetworkPointer(null);
            }
            this.externalEdges.clear();
            if (groupNet != null) {
                this.rootNetwork.removeEdges(this.metaEdges.values());
                this.metaEdges.clear();
                if (!this.nodeProvided && this.rootNetwork.containsNode(this.groupNode) && this.memberEdges.size() == 0) {
                    for (CyNetwork net : this.networkSet) {
                        net.removeNodes(Collections.singletonList(this.groupNode));
                    }
                    this.rootNetwork.removeNodes(Collections.singletonList(this.groupNode));
                }
            }
            this.networkSet.clear();
            this.collapseSet.clear();
            this.savedLocalValuesMap.clear();
            this.savedHiddenValuesMap.clear();
        }
        this.cyEventHelper.flushPayloadEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetaEdge(CyEdge edge, CyEdge metaEdge) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.metaEdges.containsKey(edge)) {
                this.metaEdges.put(edge, metaEdge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMetaEdge(CyEdge edge) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.metaEdges.containsValue(edge)) {
                for (CyEdge metaKey : this.metaEdges.keySet()) {
                    if (!this.metaEdges.get(metaKey).equals(edge)) continue;
                    this.metaEdges.remove(metaKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CyEdge> getMetaEdgeList() {
        Object object = this.lock;
        synchronized (object) {
            return this.metaEdges.values();
        }
    }

    public void removeMemberEdges() {
        HashSet<CyEdge> edgesToRemove = new HashSet<CyEdge>(this.memberEdges);
        for (CyNetwork network : this.networkSet) {
            network.removeEdges(edgesToRemove);
        }
        this.rootNetwork.removeEdges(edgesToRemove);
        this.memberEdges.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CyEdge getMetaEdge(CyEdge edge) {
        Object object = this.lock;
        synchronized (object) {
            if (this.metaEdges.containsKey(edge)) {
                return this.metaEdges.get(edge);
            }
            return null;
        }
    }

    public String toString() {
        return "Group: groupNode: " + this.groupNode + " with " + this.getGroupNetwork().getNodeCount() + " nodes, " + this.getGroupNetwork().getEdgeCount() + " internal edges and " + this.externalEdges.size() + " external edges";
    }

    private boolean inSameRoot(CyNetwork network) {
        CyRootNetwork root = ((CySubNetwork)network).getRootNetwork();
        return root.equals(this.rootNetwork);
    }

    private void throwIllegalArgumentException(String message) {
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetaEdges(boolean ignoreMetaEdges) {
        Object object = this.lock;
        synchronized (object) {
            this.metaEdges = new HashMap<CyEdge, CyEdge>();
            HashSet<CyGroup> partnersSeen = new HashSet<CyGroup>();
            ListIterator<CyEdge> iterator = new ArrayList<CyEdge>(this.externalEdges).listIterator();
            while (iterator.hasNext()) {
                CyEdge edge = iterator.next();
                CyNode node = this.getPartner(edge);
                if (ignoreMetaEdges && this.isMeta(edge)) {
                    this.addMetaEdge(edge, edge);
                    continue;
                }
                if (edge.getSource() == this.groupNode || edge.getTarget() == this.groupNode) continue;
                if (this.rootNetwork.containsEdge(edge.getSource(), this.groupNode) && this.metaAlreadyExists(edge.getSource(), this.groupNode)) {
                    this.addMetaEdge(edge, this.getMetaEdge(edge.getSource(), this.groupNode));
                    continue;
                }
                if (this.rootNetwork.containsEdge(this.groupNode, edge.getTarget()) && this.metaAlreadyExists(this.groupNode, edge.getTarget())) {
                    this.addMetaEdge(edge, this.getMetaEdge(this.groupNode, edge.getTarget()));
                    continue;
                }
                CyEdge metaEdge = this.createMetaEdge(edge, node, this.groupNode);
                if (metaEdge == null) continue;
                this.addMetaEdge(edge, metaEdge);
                for (CyNetwork net : this.networkSet) {
                    CyGroup metaPartner;
                    if (net.equals(this.rootNetwork) || (metaPartner = this.mgr.getGroup(node, net)) == null || partnersSeen.contains(metaPartner)) continue;
                    this.addPartnerEdges(metaPartner, net, partnersSeen);
                    ((CyGroupImpl)metaPartner).addMetaEdge(edge, metaEdge);
                }
            }
        }
    }

    protected int getDescendents(CyNetwork net) {
        int nDescendents = this.getGroupNetwork().getNodeCount();
        for (CyNode node : this.getGroupNetwork().getNodeList()) {
            CyGroup group = this.mgr.getGroup(node, net);
            if (group == null) continue;
            nDescendents += ((CyGroupImpl)group).getDescendents(net);
        }
        return nDescendents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPartnerEdges(CyGroup metaPartner, CyNetwork net, Set<CyGroup> partnersSeen) {
        Set partnerEdges = metaPartner.getExternalEdgeList();
        HashSet<CyEdge> newEdges = new HashSet<CyEdge>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            for (CyEdge edge : partnerEdges) {
                CyNode source = edge.getSource();
                CyNode target = edge.getTarget();
                CyNode partner = null;
                boolean directed = edge.isDirected();
                if (this.getGroupNetwork().containsNode(target)) {
                    target = this.groupNode;
                    partner = source;
                } else {
                    if (!this.getGroupNetwork().containsNode(source)) continue;
                    source = this.groupNode;
                    partner = target;
                }
                if (source == target) continue;
                CyEdge newEdge = null;
                if (!this.rootNetwork.containsEdge(source, target)) {
                    newEdge = this.rootNetwork.addEdge(source, target, directed);
                    newEdges.add(newEdge);
                }
                this.externalEdges.add(edge);
                CyGroup partnerMeta = this.mgr.getGroup(partner, net);
                if (partnerMeta != null && !partnersSeen.contains(partnerMeta)) {
                    partnersSeen.add(partnerMeta);
                    this.addPartnerEdges(partnerMeta, net, partnersSeen);
                }
                if (newEdge == null) continue;
                this.addMetaEdge(edge, newEdge);
            }
        }
        for (CyEdge edge : newEdges) {
            ((CyGroupImpl)metaPartner).addExternalEdge(edge);
        }
    }

    private CyEdge createMetaEdge(CyEdge edge, CyNode node, CyNode groupNode) {
        CyEdge metaEdge = null;
        CyNode source = null;
        CyNode target = null;
        if (this.isIncoming(edge)) {
            if (this.rootNetwork.containsEdge(node, groupNode)) {
                return (CyEdge)this.rootNetwork.getConnectingEdgeList(node, groupNode, CyEdge.Type.ANY).get(0);
            }
            metaEdge = this.rootNetwork.addEdge(node, groupNode, edge.isDirected());
            source = node;
            target = groupNode;
        } else {
            if (this.rootNetwork.containsEdge(groupNode, node)) {
                return (CyEdge)this.rootNetwork.getConnectingEdgeList(groupNode, node, CyEdge.Type.ANY).get(0);
            }
            metaEdge = this.rootNetwork.addEdge(groupNode, node, edge.isDirected());
            source = groupNode;
            target = node;
        }
        this.nameMetaEdge(metaEdge, source, target);
        this.createIfNecessary((CyIdentifiable)metaEdge, "HIDDEN", ISMETA_EDGE_ATTR, Boolean.class);
        this.rootNetwork.getRow((CyIdentifiable)metaEdge, "HIDDEN").set(ISMETA_EDGE_ATTR, (Object)Boolean.TRUE);
        return metaEdge;
    }

    private void addPartnerMetaEdges(CyNetwork net, CyEdge connectingEdge, CyGroup partnerGroup, CyEdge metaEdge) {
        if (!partnerGroup.getNetworkSet().contains(net)) {
            return;
        }
        CyEdge metaMetaEdge = null;
        CyGroupImpl partner = (CyGroupImpl)partnerGroup;
        metaMetaEdge = this.createMetaEdge(connectingEdge, partnerGroup.getGroupNode(), this.groupNode);
        if (metaMetaEdge != null) {
            partner.addMetaEdge(metaEdge, metaMetaEdge);
            this.addMetaEdge(metaEdge, metaMetaEdge);
        }
        partner.addMetaEdge(connectingEdge, metaEdge);
        for (CyEdge outerEdge : partner.getMetaEdgeList()) {
            if (!this.isConnectingEdge(outerEdge) && !partner.getPartner(outerEdge).equals(this.groupNode)) continue;
            this.addExternalEdge(outerEdge);
        }
    }

    public boolean isMeta(CyEdge edge) {
        Boolean meta = (Boolean)this.rootNetwork.getRow((CyIdentifiable)edge, "HIDDEN").get(ISMETA_EDGE_ATTR, Boolean.class, (Object)Boolean.FALSE);
        return meta;
    }

    public boolean isConnectingEdge(CyEdge edge) {
        CyNode source = edge.getSource();
        CyNode target = edge.getTarget();
        return this.getGroupNetwork().containsNode(source) || this.getGroupNetwork().containsNode(target);
    }

    public boolean isIncoming(CyEdge edge) {
        CyNode target = edge.getTarget();
        return target.equals(this.groupNode) || this.getGroupNetwork().containsNode(target);
    }

    protected CyNode getPartner(CyEdge edge) {
        CyNode source = edge.getSource();
        CyNode target = edge.getTarget();
        if (source.equals(this.groupNode) || this.getGroupNetwork().containsNode(source)) {
            return target;
        }
        return source;
    }

    private void createIfNecessary(CyIdentifiable entry, String tableName, String attribute, Class<?> type) {
        CyTable table = this.rootNetwork.getRow(entry, tableName).getTable();
        if (table.getColumn(attribute) == null) {
            table.createColumn(attribute, type, false);
        }
    }

    public void updateCountAttributes(CyNetwork net) {
        CyTable nodeTable = net.getDefaultNodeTable();
        CyColumn childrenColumn = nodeTable.getColumn(CHILDREN_ATTR);
        if (childrenColumn == null) {
            nodeTable.createColumn(CHILDREN_ATTR, Integer.class, true);
        }
        if (!nodeTable.rowExists((Object)this.groupNode.getSUID())) {
            return;
        }
        CyRow groupRow = nodeTable.getRow((Object)this.groupNode.getSUID());
        if (this.neverCollapsed) {
            groupRow.set("name", (Object)((String)groupRow.get("shared name", String.class)));
            this.neverCollapsed = false;
        }
        groupRow.set(CHILDREN_ATTR, (Object)this.getGroupNetwork().getNodeCount());
        CyColumn descendentsColumn = nodeTable.getColumn(DESCENDENTS_ATTR);
        if (descendentsColumn == null) {
            nodeTable.createColumn(DESCENDENTS_ATTR, Integer.class, true);
        }
        int nDescendents = this.getGroupNetwork().getNodeCount();
        for (CyNode node : this.getGroupNetwork().getNodeList()) {
            Integer d;
            if (!this.mgr.isGroup(node, (CyNetwork)this.rootNetwork) || (d = (Integer)nodeTable.getRow((Object)node.getSUID()).get(DESCENDENTS_ATTR, Integer.class)) == null) continue;
            nDescendents += d.intValue();
        }
        groupRow.set(DESCENDENTS_ATTR, (Object)nDescendents);
    }

    public boolean metaAlreadyExists(CyNode source, CyNode target) {
        List edges = this.rootNetwork.getConnectingEdgeList(source, target, CyEdge.Type.ANY);
        for (CyEdge groupEdge : edges) {
            if (!this.isMeta(groupEdge)) continue;
            return true;
        }
        return false;
    }

    private CyEdge getMetaEdge(CyNode source, CyNode target) {
        List edges = this.rootNetwork.getConnectingEdgeList(source, target, CyEdge.Type.ANY);
        for (CyEdge groupEdge : edges) {
            if (!this.isMeta(groupEdge)) continue;
            return groupEdge;
        }
        return null;
    }

    public boolean isCollapsing() {
        return this.collapsing;
    }

    public boolean isExpanding() {
        return this.expanding;
    }

    public boolean neverCollapsed() {
        return this.neverCollapsed;
    }

    private void saveLocalAttributes(CyNetwork net, CyIdentifiable cyObject) {
        CyRow localRow = net.getRow(cyObject, "LOCAL_ATTRS");
        Long netSuid = net.getSUID();
        if (!this.savedLocalValuesMap.containsKey(net.getSUID())) {
            this.savedLocalValuesMap.put(netSuid, new HashMap());
        }
        this.savedLocalValuesMap.get(netSuid).put(cyObject, new HashMap(localRow.getAllValues()));
        CyRow hiddenRow = net.getRow(cyObject, "HIDDEN");
        if (!this.savedHiddenValuesMap.containsKey(net.getSUID())) {
            this.savedHiddenValuesMap.put(netSuid, new HashMap());
        }
        this.savedHiddenValuesMap.get(netSuid).put(cyObject, new HashMap(hiddenRow.getAllValues()));
    }

    private void restoreLocalAttributes(CyNetwork net, Set<CyIdentifiable> cyObjects) {
        Long netSuid = net.getSUID();
        for (CyIdentifiable cyObject : cyObjects) {
            if (this.savedLocalValuesMap.containsKey(netSuid) && this.savedLocalValuesMap.get(netSuid).containsKey(cyObject)) {
                this.copyAttributes(net, cyObject, this.savedLocalValuesMap.get(netSuid).get(cyObject), net.getRow(cyObject, "LOCAL_ATTRS"));
            }
            if (!this.savedHiddenValuesMap.containsKey(cyObject) || !this.savedHiddenValuesMap.get(netSuid).containsKey(cyObject)) continue;
            this.copyAttributes(net, cyObject, this.savedHiddenValuesMap.get(netSuid).get(cyObject), net.getRow(cyObject, "HIDDEN"));
        }
    }

    private void copyAttributes(CyNetwork net, CyIdentifiable object, Map<String, Object> values, CyRow row) {
        CyTable table = row.getTable();
        for (CyColumn column : table.getColumns()) {
            if (column.getVirtualColumnInfo().isVirtual() || !values.containsKey(column.getName())) continue;
            row.set(column.getName(), values.get(column.getName()));
        }
    }

    private void copyEdgeName(CyNetwork net, CyEdge edge) {
        String localInteraction;
        String localName = (String)net.getRow((CyIdentifiable)edge).get("name", String.class);
        if (localName == null || localName.length() == 0) {
            net.getRow((CyIdentifiable)edge).set("name", (Object)((String)this.rootNetwork.getRow((CyIdentifiable)edge).get("shared name", String.class)));
        }
        if ((localInteraction = (String)net.getRow((CyIdentifiable)edge).get("interaction", String.class)) == null || localInteraction.length() == 0) {
            net.getRow((CyIdentifiable)edge).set("interaction", (Object)((String)this.rootNetwork.getRow((CyIdentifiable)edge).get("shared interaction", String.class)));
        }
    }

    private void nameMetaEdge(CyEdge edge, CyNode source, CyNode target) {
        String sourceName = (String)this.rootNetwork.getRow((CyIdentifiable)source).get("shared name", String.class);
        String targetName = (String)this.rootNetwork.getRow((CyIdentifiable)target).get("shared name", String.class);
        if (sourceName == null || targetName == null) {
            return;
        }
        if (this.rootNetwork.getRow((CyIdentifiable)edge).get("shared name", String.class) != null) {
            return;
        }
        this.rootNetwork.getRow((CyIdentifiable)edge).set("shared name", (Object)(sourceName + " (meta) " + targetName));
        this.rootNetwork.getRow((CyIdentifiable)edge).set("shared interaction", (Object)"meta");
    }

    protected void printGroup() {
        System.out.println("Group " + this);
        System.out.println("Nodes:");
        for (CyNode cyNode : this.getNodeList()) {
            System.out.println("\t" + cyNode);
        }
        System.out.println("Networks:");
        for (CyNetwork cyNetwork : this.networkSet) {
            System.out.println("\t" + cyNetwork);
        }
        System.out.println("Internal edges:");
        for (CyEdge cyEdge : this.getInternalEdgeList()) {
            System.out.println("\t" + cyEdge);
        }
        System.out.println("External edges:");
        for (CyEdge cyEdge : this.getExternalEdgeList()) {
            System.out.println("\t" + cyEdge);
        }
        System.out.println("Meta edges:");
        for (CyEdge cyEdge : this.getMetaEdgeList()) {
            System.out.println("\t" + cyEdge);
        }
        System.out.println("Member edges:");
        for (CyEdge cyEdge : this.memberEdges) {
            System.out.println("\t" + cyEdge);
        }
    }
}

