/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.group.internal;

import java.util.List;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.internal.CyGroupImpl;
import org.cytoscape.group.internal.CyGroupManagerImpl;
import org.cytoscape.group.internal.LockedVisualPropertiesManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class CyGroupFactoryImpl
implements CyGroupFactory {
    private final CyGroupManagerImpl mgr;
    private final LockedVisualPropertiesManager lvpMgr;

    public CyGroupFactoryImpl(CyGroupManagerImpl mgr, LockedVisualPropertiesManager lvpMgr) {
        if (mgr == null) {
            throw new NullPointerException("CyGroupManager is null.");
        }
        if (lvpMgr == null) {
            throw new NullPointerException("LockedVisualPropertiesManager is null.");
        }
        this.mgr = mgr;
        this.lvpMgr = lvpMgr;
    }

    public CyGroup createGroup(CyNetwork network, boolean register) {
        return this.createGroup(network, null, null, null, register);
    }

    public CyGroup createGroup(CyNetwork network, List<CyNode> nodes, List<CyEdge> edges, boolean register) {
        return this.createGroup(network, null, nodes, edges, register);
    }

    public CyGroup createGroup(CyNetwork network, CyNode node, List<CyNode> nodes, List<CyEdge> edges, boolean register) {
        CyGroupImpl group = new CyGroupImpl(this.mgr.getService(CyEventHelper.class), this.mgr, this.lvpMgr, network, node, nodes, edges);
        if (register) {
            this.mgr.addGroup(group);
        }
        return group;
    }

    public CyGroup createGroup(CyNetwork network, CyNode node, boolean register) {
        CyGroupImpl group = new CyGroupImpl(this.mgr.getService(CyEventHelper.class), this.mgr, this.lvpMgr, network, node, null, null);
        if (register) {
            this.mgr.addGroup(group);
        }
        return group;
    }
}

