/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.cytoscape.io.webservice.biomart.rest.BiomartRestClient;
import org.cytoscape.io.webservice.biomart.task.LoadRepositoryResult;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class LoadRepositoryTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger(LoadRepositoryTask.class);
    private final BiomartRestClient client;
    private Map<String, Map<String, String>> reg;
    private final Map<String, String> name2DatasourceMap;
    private LoadRepositoryResult result;
    private static final List<String> databaseFilter = new ArrayList<String>();
    private Map<String, String> datasourceMap;
    private List<String> dsList;
    @Tunable(description="")
    public ListMultipleSelection<String> services;

    public LoadRepositoryTask(BiomartRestClient client) {
        this.client = client;
        this.name2DatasourceMap = new HashMap<String, String>();
        try {
            this.initServiceList();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not obtain registry", e);
        }
    }

    private final void initServiceList() throws IOException, ParserConfigurationException, SAXException {
        this.reg = this.client.getRegistry();
        for (String databaseName : this.reg.keySet()) {
            Map<String, String> detail = this.reg.get(databaseName);
            if (!detail.get("visible").equals("1") || databaseFilter.contains(databaseName)) continue;
            String dispName = detail.get("displayName");
            this.name2DatasourceMap.put(dispName, databaseName);
        }
        TreeSet<String> sortedSet = new TreeSet<String>(this.name2DatasourceMap.keySet());
        this.services = new ListMultipleSelection(new ArrayList<String>(sortedSet));
    }

    public void run(TaskMonitor taskMonitor) throws IOException, ParserConfigurationException, SAXException {
        List selected = this.services.getSelectedValues();
        taskMonitor.setTitle("Loading list of available BioMart Services.  Please wait...");
        taskMonitor.setStatusMessage("Loading list of available Marts...");
        this.dsList = new ArrayList<String>();
        this.datasourceMap = new HashMap<String, String>();
        logger.debug("Loading Repository...");
        taskMonitor.setProgress(0.1);
        int registryCount = selected.size();
        float increment = 0.9f / (float)registryCount;
        float percentCompleted = 0.1f;
        taskMonitor.setProgress((double)percentCompleted);
        for (String databaseName : this.reg.keySet()) {
            String dispName;
            Map<String, String> detail = this.reg.get(databaseName);
            if (detail.get("visible").equals("1") && !databaseFilter.contains(databaseName) && selected.contains(dispName = detail.get("displayName"))) {
                Map<String, String> datasources;
                try {
                    datasources = this.client.getAvailableDatasets(databaseName);
                }
                catch (IOException e) {
                    percentCompleted += increment;
                    continue;
                }
                for (String key : datasources.keySet()) {
                    String dataSource = dispName + " - " + datasources.get(key);
                    this.dsList.add(dataSource);
                    this.datasourceMap.put(dataSource, key);
                    taskMonitor.setStatusMessage("Loading Data Source: " + dataSource);
                }
            }
            taskMonitor.setProgress((double)(percentCompleted += increment));
        }
        Collections.sort(this.dsList);
        taskMonitor.setStatusMessage("Finished: " + this.dsList.size());
        taskMonitor.setProgress(1.0);
        this.result = new LoadRepositoryResult(this.datasourceMap, this.dsList);
    }

    public LoadRepositoryResult getResult() {
        return this.result;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Select Services";
    }

    static {
        databaseFilter.add("compara_mart_pairwise_ga_47");
        databaseFilter.add("compara_mart_multiple_ga_47");
        databaseFilter.add("dicty");
        databaseFilter.add("Pancreatic_Expression");
    }
}

