/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.event.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cytoscape.event.CyPayloadEvent;

class PayloadAccumulator<S, P, E extends CyPayloadEvent<S, P>> {
    private final int maxSize;
    private final int maxChecked;
    private List<P> payloadList;
    private final Constructor<E> constructor;
    private Class<?> sourceClass;
    private final S source;
    private boolean ready = true;
    private int checkedCount = 0;
    private final Object lock = new Object();

    PayloadAccumulator(S source, Class<E> eventType, int maxSize, int maxChecked) throws NoSuchMethodException {
        for (Constructor<?> cons : eventType.getConstructors()) {
            Class<?>[] params = cons.getParameterTypes();
            if (params.length != 2 || params[1] != Collection.class) continue;
            this.sourceClass = params[0];
        }
        if (this.sourceClass == null) {
            throw new IllegalArgumentException("no valid source class found.");
        }
        this.source = source;
        this.maxSize = maxSize;
        this.maxChecked = maxChecked;
        this.constructor = eventType.getConstructor(this.sourceClass, Collection.class);
        this.payloadList = new ArrayList<P>();
    }

    E newEventInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassCastException {
        Collection<P> coll = this.getPayloadCollection();
        return (E)((CyPayloadEvent)this.constructor.newInstance(this.sourceClass.cast(this.source), coll));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPayload(P t) {
        Object object = this.lock;
        synchronized (object) {
            if (t != null) {
                this.ready = false;
                this.payloadList.add(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkReady() {
        Object object = this.lock;
        synchronized (object) {
            if (++this.checkedCount >= this.maxChecked) {
                return true;
            }
            if (this.payloadList.size() >= this.maxSize) {
                return true;
            }
            if (this.ready) {
                // empty if block
            }
            boolean r = this.ready;
            this.ready = true;
            return r;
        }
    }

    Object getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<P> getPayloadCollection() {
        Object object = this.lock;
        synchronized (object) {
            if (this.payloadList.isEmpty()) {
                return null;
            }
            List<P> ret = this.payloadList;
            this.payloadList = new ArrayList<P>();
            return ret;
        }
    }
}

