/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.biopax.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.biopax.internal.util.ExternalLink;

public class ExternalLinkUtil {
    private static Map dbMap;
    private static Map ihopMap;
    private static final String SPACE = "%20";
    private static final String PIPE_CHAR = "%7C";
    private static final String AMPERSAND = "&";
    private static final String COMMA = ",";
    private static final String UNIPROT_AC = "UNIPROT__AC";
    private static String pipeChar;

    public static String getUrl(String dbName, String id) {
        String url = (String)dbMap.get(dbName = dbName.toUpperCase());
        if (url != null) {
            return url + id;
        }
        return null;
    }

    public static void useUrlEncoding(boolean flag) {
        pipeChar = flag ? PIPE_CHAR : "|";
    }

    public static String createLink(String dbName, String id) {
        dbName = dbName.toUpperCase();
        String url = ExternalLinkUtil.getUrl(dbName, id);
        StringBuffer buf = new StringBuffer();
        if (url != null) {
            buf.append("<a class=\"link\" href=\"" + url + "\">" + dbName + ":  " + id + "</a>");
        } else {
            buf.append(dbName + ":  " + id);
        }
        return buf.toString();
    }

    public static String getIHOPUrl(String type, List synList, List dbList, int taxonomyId) {
        if (type.equalsIgnoreCase("protein") || type.equalsIgnoreCase("dna") || type.equalsIgnoreCase("rna")) {
            StringBuffer url = new StringBuffer();
            String synonymParameter = ExternalLinkUtil.createSynonymParameter(synList);
            String dbParameter = ExternalLinkUtil.createDbParameter(dbList, synList);
            url.append(synonymParameter);
            if (dbParameter != null && dbParameter.length() > 0) {
                ExternalLinkUtil.appendAmpersand(synonymParameter, url);
                url.append(dbParameter);
            }
            if (url.length() > 0) {
                url.insert(0, "http://www.ihop-net.org/UniPub/iHOP/in?");
                return url.toString().replaceAll("\\s", SPACE);
            }
        }
        return null;
    }

    private static void appendAmpersand(String param, StringBuffer url) {
        if (param.length() > 0) {
            url.append(AMPERSAND);
        }
    }

    private static String createDbParameter(List dbList, List synList) {
        int dbHits = 0;
        int uniProtHits = 0;
        StringBuffer temp = new StringBuffer();
        if (dbList != null && dbList.size() > 0) {
            for (int i = 0; i < dbList.size(); ++i) {
                String code;
                ExternalLink link = (ExternalLink)dbList.get(i);
                if (link == null || link.getDbName() == null || (code = (String)ihopMap.get(link.getDbName().toUpperCase())) == null) continue;
                if (code.equals(UNIPROT_AC)) {
                    ++uniProtHits;
                }
                ++dbHits;
                temp.append(code + pipeChar + link.getId() + COMMA);
            }
            if (temp.length() > 0) {
                if (uniProtHits == dbHits && synList.size() == 0) {
                    return new String();
                }
                temp.insert(0, "dbrefs_1=");
                return temp.substring(0, temp.length() - 1);
            }
        }
        return new String();
    }

    private static String createSynonymParameter(List synList) {
        StringBuffer temp = new StringBuffer();
        if (synList != null && synList.size() > 0) {
            temp.append("syns_1=");
            for (int i = 0; i < synList.size(); ++i) {
                temp.append((String)synList.get(i));
                if (i >= synList.size() - 1) continue;
                temp.append(pipeChar);
            }
        }
        return temp.toString();
    }

    public static String createIHOPLink(String type, List synList, List linkList, int taxonomyId) {
        String url = ExternalLinkUtil.getIHOPUrl(type, synList, linkList, taxonomyId);
        if (url != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<A class=\"link\" HREF=\"" + url + "\">Search iHOP</A>");
            return buf.toString();
        }
        return null;
    }

    private static void addIHOPEntries(HashMap map, String iHopCode) {
        for (String key : map.keySet()) {
            ihopMap.put(key, iHopCode);
        }
    }

    static {
        pipeChar = PIPE_CHAR;
        dbMap = new HashMap();
        ihopMap = new HashMap();
        String url = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids=";
        dbMap.put("PUBMED", url);
        dbMap.put("PMID", url);
        url = "http://hprd.org/protein/";
        dbMap.put("HPRD", url);
        url = "http://www.pir.uniprot.org/cgi-bin/upEntry?id=";
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("UNIPROT", url);
        temp.put("SWISSPROT", url);
        temp.put("SWP", url);
        temp.put("SWISS-PROT", url);
        dbMap.putAll(temp);
        ExternalLinkUtil.addIHOPEntries(temp, UNIPROT_AC);
        url = "http://www.godatabase.org/cgi-bin/amigo/go.cgi?open_1=";
        dbMap.put("GO", url);
        url = "http://reactome.org/cgi-bin/eventbrowser?DB=gk_current&ID=";
        dbMap.put("REACTOME DATABASE ID", url);
        url = "http://www.reactome.org/cgi-bin/eventbrowser_st_id?FROM_REACTOME=1&amp;ST_ID=";
        dbMap.put("REACTOME", url);
        dbMap.put("REACTOME STABLE ID", url);
        url = "http://www.rcsb.org/pdb/cgi/explore.cgi?pdbId=";
        dbMap.put("PDB", url);
        url = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene&cmd=search&term=";
        temp = new HashMap();
        temp.put("REFSEQ", url);
        temp.put("REF-SEQ", url);
        temp.put("REF_SEQ", url);
        dbMap.putAll(temp);
        ExternalLinkUtil.addIHOPEntries(temp, "NCBI_REFSEQ__NP");
        url = "http://www.ncbi.nlm.nih.gov/entrez/dispomim.cgi?id=";
        dbMap.put("OMIM", url);
        url = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene&cmd=search&term=";
        temp = new HashMap();
        temp.put("ENTREZGENE", url);
        temp.put("ENTREZ_GENE", url);
        temp.put("LOCUS_LINK", url);
        temp.put("LOCUSLINK", url);
        temp.put("LOCUS-LINK", url);
        dbMap.putAll(temp);
        ExternalLinkUtil.addIHOPEntries(temp, "NCBI_GENE__ID");
        url = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=unigene&cmd=search&term=";
        dbMap.put("UNIGENE", url);
        url = "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=protein&val=";
        dbMap.put("GENBANK", url);
        dbMap.put("ENTREZ_GI", url);
        dbMap.put("GI", url);
    }
}

